/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.MessageHeaderInfo;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;

public abstract class MessagePartContainer {
    private OperationInfo operation;
    private Map messageHeaders = new HashMap();
    private Map messageParts = new HashMap();
    private List messageHeaderList = new LinkedList();
    private List messagePartList = new LinkedList();

    protected MessagePartContainer(OperationInfo operation) {
        this.operation = operation;
    }

    public OperationInfo getOperation() {
        return this.operation;
    }

    public MessagePartInfo addMessagePart(QName name, Class clazz) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        if (this.messageParts.containsKey(name)) {
            throw new IllegalArgumentException("An message part with name [" + name + "] already exists in this container");
        }
        MessagePartInfo part = new MessagePartInfo(name, clazz, this);
        this.addMessagePart(part);
        return part;
    }

    public MessageHeaderInfo addMessageHeader(QName name, Class clazz) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        if (this.messageParts.containsKey(name)) {
            throw new IllegalArgumentException("An message header with name [" + name + "] already exists in this container");
        }
        MessageHeaderInfo part = new MessageHeaderInfo(name, clazz, this);
        this.addMessageHeader(part);
        return part;
    }

    public void addMessagePart(MessagePartInfo part) {
        this.messageParts.put(part.getName(), part);
        this.messagePartList.add(part);
    }

    public void addMessageHeader(MessageHeaderInfo header) {
        this.messageHeaders.put(header.getName(), header);
        this.messageHeaderList.add(header);
    }

    public int getMessagePartIndex(MessagePartInfo part) {
        return this.messagePartList.indexOf(part);
    }

    public void removeMessagePart(QName name) {
        MessagePartInfo messagePart = this.getMessagePart(name);
        if (messagePart != null) {
            this.messageParts.remove(name);
            this.messagePartList.remove(messagePart);
        }
    }

    public void removeMessageHeader(QName name) {
        MessageHeaderInfo messageHeader = this.getMessageHeader(name);
        if (messageHeader != null) {
            this.messageHeaders.remove(name);
            this.messageHeaderList.remove(messageHeader);
        }
    }

    public MessagePartInfo getMessagePart(QName name) {
        return (MessagePartInfo)this.messageParts.get(name);
    }

    public MessageHeaderInfo getMessageHeader(QName name) {
        return (MessageHeaderInfo)this.messageHeaders.get(name);
    }

    public List getMessageParts() {
        return Collections.unmodifiableList(this.messagePartList);
    }

    public List getMessageHeaders() {
        return Collections.unmodifiableList(this.messageHeaderList);
    }
}

