/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.fault;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.xfire.XFireException;
import org.codehaus.yom.Element;

public class XFireFault
extends XFireException {
    private static final long serialVersionUID = 1L;
    public static final String VERSION_MISMATCH = "VersionMismatch";
    public static final String MUST_UNDERSTAND = "MustUnderstand";
    public static final String DATA_ENCODING_UNKNOWN = "DataEncodingUnknown";
    public static final String SENDER = "Sender";
    public static final String RECEIVER = "Receiver";
    private String faultCode;
    private String subCode;
    private String message;
    private String role;
    private Element detail;
    private Map namespaces;
    private Throwable cause;

    public static XFireFault createFault(Throwable throwable) {
        XFireFault fault = null;
        fault = throwable instanceof XFireFault ? (XFireFault)throwable : new XFireFault(throwable);
        return fault;
    }

    protected XFireFault() {
    }

    public XFireFault(Throwable throwable) {
        this(throwable.getMessage(), throwable, RECEIVER);
    }

    public XFireFault(Throwable throwable, String code) {
        this(throwable.getMessage(), throwable, code);
    }

    public XFireFault(String message, String code) {
        this(message, null, code);
    }

    public XFireFault(String message, Throwable cause, String code) {
        this.message = message != null ? message : "Fault";
        this.faultCode = code;
        this.cause = cause;
        this.namespaces = new HashMap();
    }

    public void addNamespace(String prefix, String ns) {
        this.namespaces.put(prefix, ns);
    }

    public void printStackTrace(PrintStream s) {
        if (this.cause == null || this.cause == this) {
            super.printStackTrace(s);
        } else {
            s.println(this);
            this.cause.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter w) {
        if (this.cause == null || this.cause == this) {
            super.printStackTrace(w);
        } else {
            w.println(this);
            this.cause.printStackTrace(w);
        }
    }

    public Throwable getCause() {
        return this.cause == this ? null : this.cause;
    }

    public Element getDetail() {
        if (this.detail == null) {
            this.detail = new Element("detail");
        }
        return this.detail;
    }

    public void setDetail(Element details) {
        this.detail = details;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public String getReason() {
        return this.getMessage();
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String actor) {
        this.role = actor;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public boolean hasDetails() {
        return this.detail != null;
    }
}

