/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.fault;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.MessageSerializer;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;
import org.codehaus.yom.stax.StaxBuilder;
import org.codehaus.yom.stax.StaxSerializer;

public class Soap11FaultSerializer
implements MessageSerializer {
    private StaxBuilder builder = new StaxBuilder();

    public void readMessage(InMessage message, MessageContext context) throws XFireFault {
        XFireFault fault = new XFireFault();
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            boolean end = false;
            while (!end && reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 7: {
                        String encoding = reader.getCharacterEncodingScheme();
                        message.setEncoding(encoding);
                        break;
                    }
                    case 8: {
                        end = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1: {
                        if (reader.getLocalName().equals("faultcode")) {
                            fault.setFaultCode(reader.getElementText());
                            break;
                        }
                        if (reader.getLocalName().equals("faultstring")) {
                            fault.setMessage(reader.getElementText());
                            break;
                        }
                        if (reader.getLocalName().equals("faultactor")) {
                            fault.setRole(reader.getElementText());
                            break;
                        }
                        if (!reader.getLocalName().equals("detail")) break;
                        fault.setDetail(this.builder.buildElement(null, reader));
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Could not parse message.", e, "Sender");
        }
        message.setBody(fault);
    }

    public void writeMessage(OutMessage message, XMLStreamWriter writer, MessageContext context) throws XFireFault {
        XFireFault fault = (XFireFault)message.getBody();
        try {
            Map namespaces = fault.getNamespaces();
            Iterator itr = namespaces.keySet().iterator();
            while (itr.hasNext()) {
                String prefix = (String)itr.next();
                writer.writeAttribute("xmlns:" + prefix, (String)namespaces.get(prefix));
            }
            writer.writeStartElement("soap:Fault");
            writer.writeStartElement("faultcode");
            String codeString = fault.getFaultCode();
            if (codeString.equals("Receiver")) {
                codeString = "Server";
            }
            if (codeString.equals("Sender")) {
                codeString = "Server";
            } else if (codeString.equals("DataEncodingUnknown")) {
                codeString = "Client";
            }
            writer.writeCharacters(codeString);
            writer.writeEndElement();
            writer.writeStartElement("faultstring");
            writer.writeCharacters(fault.getMessage());
            writer.writeEndElement();
            if (fault.hasDetails()) {
                Element detail = fault.getDetail();
                writer.writeStartElement("detail");
                StaxSerializer serializer = new StaxSerializer();
                Elements details = detail.getChildElements();
                for (int i = 0; i < details.size(); ++i) {
                    serializer.writeElement(details.get(i), writer);
                }
                writer.writeEndElement();
            }
            if (fault.getRole() != null) {
                writer.writeStartElement("faultactor");
                writer.writeCharacters(fault.getRole());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException xe) {
            throw new XFireRuntimeException("Couldn't create fault.", xe);
        }
    }
}

