/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client.http;

import java.net.URLConnection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.client.ClientHandler;
import org.codehaus.xfire.client.http.AbstractHttpClient;
import org.codehaus.xfire.fault.XFireFault;

public class SoapHttpClient
extends AbstractHttpClient {
    private ClientHandler bodyHandler;
    private ClientHandler headerHandler;
    private String soapVersion;
    private String action = "";

    public SoapHttpClient(ClientHandler bodyHandler, String url) {
        this.bodyHandler = bodyHandler;
        this.setUrl(url);
        this.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope/");
    }

    public SoapHttpClient(ClientHandler bodyHandler, ClientHandler headerHandler, String url) {
        this.bodyHandler = bodyHandler;
        this.headerHandler = headerHandler;
        this.setUrl(url);
        this.setSoapVersion("http://schemas.xmlsoap.org/soap/envelope/");
    }

    public SoapHttpClient(ClientHandler bodyHandler, ClientHandler headerHandler, String url, String soapVersion) {
        this.bodyHandler = bodyHandler;
        this.headerHandler = headerHandler;
        this.soapVersion = soapVersion;
        this.setUrl(url);
    }

    protected void writeRequest(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument(this.getEncoding(), "1.0");
        writer.setPrefix("soap", this.getSoapVersion());
        writer.writeStartElement("soap", "Envelope", this.soapVersion);
        writer.writeNamespace("soap", this.getSoapVersion());
        if (this.headerHandler != null) {
            writer.writeStartElement("soap", "Header", this.soapVersion);
            this.headerHandler.writeRequest(writer);
            writer.writeEndElement();
        }
        writer.writeStartElement("soap", "Body", this.soapVersion);
        this.bodyHandler.writeRequest(writer);
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
    }

    protected void readResponse(XMLStreamReader reader) throws XMLStreamException, XFireFault {
        while (true) {
            int event = reader.next();
            switch (event) {
                case 8: {
                    return;
                }
                case 1: {
                    if (reader.getLocalName().equals("Header") && this.headerHandler != null) {
                        reader.nextTag();
                        this.headerHandler.handleResponse(reader);
                        break;
                    }
                    if (!reader.getLocalName().equals("Body")) break;
                    reader.nextTag();
                    this.bodyHandler.handleResponse(reader);
                    break;
                }
            }
        }
    }

    protected void writeHeaders(URLConnection urlConn) {
        String action = this.getAction();
        if (action == null) {
            action = "";
        }
        urlConn.setRequestProperty("SOAPAction", "\"" + action + "\"");
    }

    public ClientHandler getBodyHandler() {
        return this.bodyHandler;
    }

    public ClientHandler getHeaderHandler() {
        return this.headerHandler;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }
}

