/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client.http;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.fault.XFireFault;

public abstract class AbstractHttpClient {
    public static final String SOAP11_ENVELOPE_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_ENVELOPE_NS = "http://www.w3.org/2003/05/soap-envelope";
    private String username;
    private String password;
    private String encoding = "UTF-8";
    private String urlString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws IOException, XFireFault {
        URL url = new URL(this.urlString);
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        try {
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConn.setRequestProperty("Content-type", "text/xml; charset=" + this.encoding);
            urlConn.setRequestProperty("User-Agent", "XFire Client +http://xfire.codehaus.org");
            urlConn.setRequestProperty("Accept", "text/xml; text/html");
            this.writeHeaders(urlConn);
            OutputStream out = urlConn.getOutputStream();
            this.writeRequest(out);
            out.write(10);
            out.flush();
            out.close();
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(urlConn.getInputStream());
                this.readResponse(reader);
            }
            catch (IOException ioe) {
                if (urlConn.getResponseCode() == 500) {
                    reader = new InputStreamReader(urlConn.getErrorStream());
                    this.readResponse(reader);
                }
            }
            finally {
                if (reader != null) {
                    ((Reader)reader).close();
                }
            }
        }
        catch (MalformedURLException me) {
            throw new XFireRuntimeException("Bad URL.", me);
        }
        finally {
            urlConn.disconnect();
        }
    }

    protected void writeHeaders(URLConnection urlConn) {
    }

    protected void writeRequest(OutputStream out) {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter writer = factory.createXMLStreamWriter(out);
            this.writeRequest(writer);
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    protected abstract void writeRequest(XMLStreamWriter var1) throws XMLStreamException;

    protected void readResponse(Reader is) throws XFireFault {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.readResponse(factory.createXMLStreamReader(is));
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Couldn't parse stream.", e);
        }
    }

    protected abstract void readResponse(XMLStreamReader var1) throws XMLStreamException, XFireFault;

    public String getUrl() {
        return this.urlString;
    }

    public void setUrl(String url) {
        this.urlString = url;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String charset) {
        this.encoding = charset;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

