/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.client;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.exchange.RobustInOutExchange;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandlerSupport;
import org.codehaus.xfire.handler.HandlerPipeline;
import org.codehaus.xfire.handler.OutMessageSender;
import org.codehaus.xfire.handler.ParseMessageHandler;
import org.codehaus.xfire.handler.Phase;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.service.binding.ObjectBinding;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.ChannelEndpoint;
import org.codehaus.xfire.transport.Transport;

public class Client
extends AbstractHandlerSupport
implements ChannelEndpoint {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$client$Client == null ? (class$org$codehaus$xfire$client$Client = Client.class$("org.codehaus.xfire.client.Client")) : class$org$codehaus$xfire$client$Client));
    private Object[] response;
    private Transport transport;
    private Service service;
    private ObjectBinding clientBinding;
    private String url;
    private int timeout = 10000;
    private MessageContext context;
    private XFireFault fault;
    private String endpointUri;
    private List inPhases;
    private List outPhases;
    private XFire xfire;
    static /* synthetic */ Class class$org$codehaus$xfire$client$Client;

    public Client(Transport transport, Service service, String url) {
        this(transport, service, url, null);
    }

    public Client(Transport transport, Service service, String url, String endpointUri) {
        this.transport = transport;
        this.url = url;
        this.endpointUri = endpointUri;
        this.clientBinding = (ObjectBinding)((AbstractBinding)service.getBinding()).clone();
        this.clientBinding.setClientModeOn(true);
        this.service = new Service(service.getServiceInfo());
        this.service.setBinding(this.clientBinding);
        this.service.setFaultSerializer(service.getFaultSerializer());
        this.service.setSoapVersion(service.getSoapVersion());
        this.inPhases = new ArrayList();
        this.outPhases = new ArrayList();
        this.createPhases();
        this.addOutHandler(new OutMessageSender());
        this.addInHandler(new ParseMessageHandler());
    }

    public Object[] invoke(OperationInfo op, Object[] params) throws XFireException, XFireFault {
        try {
            OutMessage msg = new OutMessage("targeturl");
            msg.setBody(params);
            msg.setUri(this.url);
            msg.setSerializer(this.service.getBinding());
            msg.setAction(op.getAction());
            msg.setChannel(this.getOutChannel());
            this.context = new MessageContext();
            this.context.setService(this.service);
            this.context.setXFire(this.xfire);
            RobustInOutExchange exchange = new RobustInOutExchange(this.context);
            exchange.setOperation(op);
            exchange.setOutMessage(msg);
            this.context.setExchange(exchange);
            HandlerPipeline pipeline = new HandlerPipeline(this.outPhases);
            pipeline.addHandlers(this.getOutHandlers());
            pipeline.addHandlers(this.transport.getOutHandlers());
            pipeline.invoke(this.context);
        }
        catch (Exception e1) {
            throw XFireFault.createFault(e1);
        }
        if (this.response == null && this.fault == null) {
            for (int count = 0; this.response == null && this.fault == null && count < this.timeout; count += 50) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        if (this.fault != null) {
            XFireFault localFault = this.fault;
            this.fault = null;
            throw localFault;
        }
        Object[] localResponse = this.response;
        this.response = null;
        return localResponse;
    }

    public void onReceive(MessageContext recvContext, InMessage msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message to " + msg.getUri()));
        }
        if (this.context.getExchange() == null) {
            this.context.setExchange(new RobustInOutExchange(this.context));
        }
        RobustInOutExchange exchange = (RobustInOutExchange)this.context.getExchange();
        exchange.setInMessage(msg);
        HandlerPipeline pipeline = new HandlerPipeline(this.inPhases);
        pipeline.addHandlers(this.getInHandlers());
        pipeline.addHandlers(this.transport.getInHandlers());
        try {
            pipeline.invoke(this.context);
            this.finishReadingMessage(msg, this.context);
            this.response = ((List)msg.getBody()).toArray();
        }
        catch (Exception e1) {
            XFireFault fault = XFireFault.createFault(e1);
            pipeline.handleFault(fault, this.context);
            this.fault = fault;
        }
    }

    public void finishReadingMessage(InMessage message, MessageContext context) throws XFireFault {
        XMLStreamReader reader = message.getXMLStreamReader();
        try {
            while (reader.hasNext()) {
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XFireFault("Couldn't parse message.", e, "Sender");
        }
    }

    protected void createPhases() {
        this.inPhases = new ArrayList();
        this.inPhases.add(new Phase("transport", 1000));
        this.inPhases.add(new Phase("parse", 2000));
        this.inPhases.add(new Phase("pre-dispatch", 3000));
        this.inPhases.add(new Phase("dispatch", 4000));
        this.inPhases.add(new Phase("policy", 5000));
        this.inPhases.add(new Phase("user", 6000));
        this.inPhases.add(new Phase("pre-invoke", 7000));
        this.inPhases.add(new Phase("service", 8000));
        this.outPhases = new ArrayList();
        this.outPhases.add(new Phase("post-invoke", 1000));
        this.outPhases.add(new Phase("policy", 2000));
        this.outPhases.add(new Phase("user", 3000));
        this.outPhases.add(new Phase("transport", 4000));
        this.outPhases.add(new Phase("send", 5000));
    }

    public Channel getOutChannel() {
        Channel channel = null;
        try {
            String uri = this.getEndpointUri();
            channel = uri == null ? this.getTransport().createChannel() : this.getTransport().createChannel(uri);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't open channel.", e);
        }
        channel.setEndpoint(this);
        return channel;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void receive(Object response) {
        this.response = ((List)response).toArray();
    }

    public Service getService() {
        return this.service;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void receiveFault(XFireFault fault) {
        this.fault = fault;
    }

    public XFire getXFire() {
        return this.xfire;
    }

    public void setXFire(XFire xfire) {
        this.xfire = xfire;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

