/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.addressing;

import java.util.ArrayList;
import org.codehaus.xfire.addressing.AbstactAddressingHeadersFactory;
import org.codehaus.xfire.addressing.AddressingHeaders;
import org.codehaus.xfire.addressing.AddressingHeadersFactory;
import org.codehaus.xfire.addressing.EndpointReference;
import org.codehaus.xfire.addressing.WSAConstants;
import org.codehaus.yom.Attribute;
import org.codehaus.yom.Element;
import org.codehaus.yom.Elements;
import org.codehaus.yom.Node;

public class AddressingHeadersFactory200502
extends AbstactAddressingHeadersFactory
implements WSAConstants,
AddressingHeadersFactory {
    public AddressingHeaders createHeaders(Element root) {
        Element action;
        Element to;
        Element messageId;
        Element faultTo;
        Element replyTo;
        AddressingHeaders headers = new AddressingHeaders();
        Element from = root.getFirstChildElement("From", "http://www.w3.org/2005/02/addressing");
        if (from != null) {
            headers.setFrom(this.createEPR(from));
        }
        if ((replyTo = root.getFirstChildElement("ReplyTo", "http://www.w3.org/2005/02/addressing")) != null) {
            headers.setReplyTo(this.createEPR(replyTo));
        }
        if ((faultTo = root.getFirstChildElement("FaultTo", "http://www.w3.org/2005/02/addressing")) != null) {
            headers.setFaultTo(this.createEPR(faultTo));
        }
        if ((messageId = root.getFirstChildElement("MessageID", "http://www.w3.org/2005/02/addressing")) != null) {
            headers.setMessageID(messageId.getValue());
        }
        if ((to = root.getFirstChildElement("To", "http://www.w3.org/2005/02/addressing")) != null) {
            headers.setTo(to.getValue());
        }
        if ((action = root.getFirstChildElement("Action", "http://www.w3.org/2005/02/addressing")) != null) {
            headers.setAction(action.getValue());
        }
        return headers;
    }

    public EndpointReference createEPR(Element eprElement) {
        EndpointReference epr = new EndpointReference();
        ArrayList<Element> anyContent = null;
        Elements elements = eprElement.getChildElements();
        String version = eprElement.getNamespaceURI();
        for (int i = 0; i < elements.size(); ++i) {
            Element e = elements.get(i);
            if (!e.getNamespaceURI().equals(version)) continue;
            if (e.getLocalName().equals("Address")) {
                epr.setAddress(e.getValue());
                continue;
            }
            if (e.getLocalName().equals("ServiceName")) {
                epr.setServiceName(AddressingHeadersFactory200502.elementToQName(e));
                epr.setEndpointName(e.getAttributeValue("EndpointName", version));
                continue;
            }
            if (e.getLocalName().equals("InterfaceName")) {
                epr.setInterfaceName(AddressingHeadersFactory200502.elementToQName(e));
                continue;
            }
            if (e.getLocalName().equals("Policies")) {
                ArrayList<Element> policies = new ArrayList<Element>();
                Elements polEls = e.getChildElements();
                for (int j = 0; j < polEls.size(); ++j) {
                    policies.add(polEls.get(j));
                }
                epr.setPolicies(policies);
                continue;
            }
            if (anyContent == null) {
                anyContent = new ArrayList<Element>();
            }
            anyContent.add(e);
        }
        if (anyContent != null) {
            epr.setAny(anyContent);
        }
        return epr;
    }

    public boolean hasHeaders(Element root) {
        return root.getFirstChildElement("Action", "http://www.w3.org/2005/02/addressing") != null;
    }

    public void writeHeaders(Element root, AddressingHeaders headers) {
        String ns = "http://www.w3.org/2005/02/addressing";
        root.addNamespaceDeclaration("wsa", "http://www.w3.org/2005/02/addressing");
        if (headers.getTo() != null) {
            Element to = new Element("wsa:To", "http://www.w3.org/2005/02/addressing");
            to.appendChild(headers.getTo());
            root.appendChild((Node)to);
        }
        if (headers.getAction() != null) {
            Element action = new Element("wsa:Action", "http://www.w3.org/2005/02/addressing");
            action.appendChild(headers.getAction());
            root.appendChild((Node)action);
        }
        if (headers.getFaultTo() != null) {
            Element faultTo = new Element("wsa:FaultTo", "http://www.w3.org/2005/02/addressing");
            root.appendChild((Node)faultTo);
            this.writeEPR(faultTo, headers.getFaultTo());
        }
        if (headers.getFrom() != null) {
            Element from = new Element("wsa:From", "http://www.w3.org/2005/02/addressing");
            root.appendChild((Node)from);
            this.writeEPR(from, headers.getFrom());
        }
        if (headers.getMessageID() != null) {
            Element messageId = new Element("wsa:MessageID", "http://www.w3.org/2005/02/addressing");
            messageId.appendChild(headers.getMessageID());
            root.appendChild((Node)messageId);
        }
        if (headers.getRelatesTo() != null) {
            Element relatesTo = new Element("wsa:RelatesTo", "http://www.w3.org/2005/02/addressing");
            relatesTo.appendChild(headers.getRelatesTo());
            root.appendChild((Node)relatesTo);
            if (headers.getRelationshipType() != null) {
                String value = AddressingHeadersFactory200502.qnameToString(root, headers.getRelationshipType());
                relatesTo.addAttribute(new Attribute("RelationshipType", value));
            }
        }
        if (headers.getReplyTo() != null) {
            Element replyTo = new Element("wsa:ReplyTo", "http://www.w3.org/2005/02/addressing");
            root.appendChild((Node)replyTo);
            this.writeEPR(replyTo, headers.getReplyTo());
        }
    }

    public void writeEPR(Element root, EndpointReference epr) {
        String ns = "http://www.w3.org/2005/02/addressing";
        Element address = new Element("wsa:Address", "http://www.w3.org/2005/02/addressing");
        address.appendChild(epr.getAddress());
        root.appendChild((Node)address);
        if (epr.getServiceName() != null) {
            Element serviceName = new Element("wsa:ServiceName", "http://www.w3.org/2005/02/addressing");
            serviceName.appendChild(AddressingHeadersFactory200502.qnameToString((Element)root.getParent(), epr.getServiceName()));
            root.appendChild((Node)serviceName);
            if (epr.getInterfaceName() != null) {
                String value = AddressingHeadersFactory200502.qnameToString((Element)root.getParent(), epr.getInterfaceName());
                serviceName.addAttribute(new Attribute("wsa:InterfaceName", value));
            }
        }
    }

    public String getAnonymousUri() {
        return "http://www.w3.org/2005/02/addressing/role/anonymous";
    }
}

