/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.xmlbeans;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.util.stax.FragmentStreamReader;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.builder.WSDLBuilder;
import org.codehaus.xfire.xmlbeans.XmlBeansType;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class XmlBeansWSDLBuilder
extends WSDLBuilder {
    private static final StaxBuilder builder = new StaxBuilder();
    private static Map schemas = new HashMap();
    private List importedSchemas = new ArrayList();

    public XmlBeansWSDLBuilder(Service service) throws WSDLException {
        super(service);
    }

    public void addDependency(SchemaType type) {
        if (!this.hasDependency(type) && type instanceof XmlBeansType) {
            XmlBeansType xbeanType = (XmlBeansType)type;
            Element schema = this.getSchema(xbeanType);
            String ns = xbeanType.getSchemaType().getNamespaceURI();
            if (!this.importedSchemas.contains(schema)) {
                schema.detach();
                this.setSchema(ns, schema);
                this.importedSchemas.add(schema);
            }
        }
        super.addDependency(type);
    }

    public Element getSchema(XmlBeansType xbeanType) {
        org.apache.xmlbeans.SchemaType type = XmlBeans.typeForClass((Class)xbeanType.getTypeClass());
        String name = type.getSourceName();
        if (name == null) {
            return null;
        }
        Element schema = (Element)schemas.get(name);
        if (schema != null) {
            return schema;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            XmlObject obj = XmlObject.Factory.parse((InputStream)classLoader.getResourceAsStream("schemaorg_apache_xmlbeans/src/" + name));
            schema = builder.build(new FragmentStreamReader(obj.newXMLStreamReader())).getRootElement();
            String ns = xbeanType.getSchemaType().getNamespaceURI();
            String expr = "//xsd:schema[@targetNamespace='" + ns + "']";
            List nodes = this.getMatches(schema, expr);
            if (nodes.size() == 0) {
                return null;
            }
            schema = (Element)nodes.get(0);
            schemas.put(name, schema);
            return schema;
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't load schema.", e);
        }
    }

    private List getMatches(Object doc, String xpath) {
        try {
            XPath path = XPath.newInstance((String)xpath);
            path.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            path.addNamespace("s", "http://www.w3.org/2001/XMLSchema");
            List result = path.selectNodes(doc);
            return result;
        }
        catch (JDOMException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, e);
        }
    }
}

