/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.wsdl.WSDLException;
import org.codehaus.xfire.wsdl.WSDLWriter;

public class ResourceWSDL
implements WSDLWriter {
    private final URL wsdlUrl;

    public ResourceWSDL(String wsdlUrl) throws WSDLException {
        try {
            this.wsdlUrl = new URL(wsdlUrl);
        }
        catch (MalformedURLException e) {
            throw new WSDLException("CONFIGURATION_ERROR", "Invalid URL to WSDL file", (Throwable)e);
        }
    }

    public ResourceWSDL(URL wsdlUrl) {
        this.wsdlUrl = wsdlUrl;
    }

    public void write(OutputStream out) throws IOException {
        this.copy(this.wsdlUrl.openStream(), out, 8096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            byte[] buffer = new byte[bufferSize];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
        }
        finally {
            input.close();
        }
    }
}

