/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.transport.http.HttpTransport;
import org.codehaus.xfire.transport.http.SimpleMessageSender;
import org.codehaus.xfire.transport.http.XFireServletController;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.STAXUtils;

public class HttpChannel
extends AbstractChannel {
    private static final Log log = LogFactory.getLog((Class)(class$org$codehaus$xfire$transport$http$HttpChannel == null ? (class$org$codehaus$xfire$transport$http$HttpChannel = HttpChannel.class$("org.codehaus.xfire.transport.http.HttpChannel")) : class$org$codehaus$xfire$transport$http$HttpChannel));
    static /* synthetic */ Class class$org$codehaus$xfire$transport$http$HttpChannel;
    static /* synthetic */ Class class$org$codehaus$xfire$exchange$OutMessage;
    static /* synthetic */ Class class$org$codehaus$xfire$MessageContext;

    public HttpChannel(String uri, HttpTransport transport) {
        this.setTransport(transport);
        this.setUri(uri);
    }

    public void open() {
    }

    public void send(MessageContext context, OutMessage message) throws XFireException {
        if (message.getUri().equals("urn:xfire:channel:backchannel")) {
            HttpServletResponse response = XFireServletController.getResponse();
            if (response == null) {
                throw new XFireRuntimeException("No backchannel exists for message");
            }
            Attachments atts = message.getAttachments();
            if (atts != null && atts.size() > 0) {
                throw new UnsupportedOperationException("Sending attachments isn't supported at this time.");
            }
            try {
                ServletOutputStream out = response.getOutputStream();
                XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, message.getEncoding());
                message.getSerializer().writeMessage(message, writer, context);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                if (e instanceof XFireException) {
                    throw (XFireException)e;
                }
                if (e instanceof XFireRuntimeException) {
                    throw (XFireRuntimeException)e;
                }
                throw new XFireException("Couldn't send message.", e);
            }
        } else {
            this.sendViaClient(context, message);
        }
    }

    private void sendViaClient(MessageContext context, OutMessage message) throws XFireException {
        AbstractMessageSender sender;
        try {
            Class chms = ClassLoaderUtils.loadClass("org.codehaus.xfire.transport.http.CommonsHttpMessageSender", this.getClass());
            Constructor constructor = chms.getConstructor(class$org$codehaus$xfire$exchange$OutMessage == null ? (class$org$codehaus$xfire$exchange$OutMessage = HttpChannel.class$("org.codehaus.xfire.exchange.OutMessage")) : class$org$codehaus$xfire$exchange$OutMessage, class$org$codehaus$xfire$MessageContext == null ? (class$org$codehaus$xfire$MessageContext = HttpChannel.class$("org.codehaus.xfire.MessageContext")) : class$org$codehaus$xfire$MessageContext);
            sender = (AbstractMessageSender)constructor.newInstance(message, context);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not load commons http client. Using buggy SimpleMessageSender instead.");
            }
            sender = new SimpleMessageSender(message, context);
        }
        try {
            ((AbstractMessageSender)sender).open();
            ((AbstractMessageSender)sender).send();
            this.getEndpoint().onReceive(context, ((AbstractMessageSender)sender).getInMessage());
        }
        catch (IOException e) {
            throw new XFireException("Couldn't send message.", e);
        }
        finally {
            ((AbstractMessageSender)sender).close();
        }
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

