/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.aegis.MessageReader;
import org.codehaus.xfire.aegis.MessageWriter;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.basic.BeanTypeInfo;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.util.NamespaceHelper;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class BeanType
extends Type {
    private BeanTypeInfo _info;
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil", "xsi");

    public BeanType() {
        this.setNillable(true);
    }

    public BeanType(BeanTypeInfo info) {
        this._info = info;
        this.setNillable(true);
        this.setTypeClass(info.getTypeClass());
    }

    public Object readObject(MessageReader reader, MessageContext context) throws XFireFault {
        BeanTypeInfo info = this.getTypeInfo();
        try {
            Type type;
            QName name;
            MessageReader childReader;
            Class clazz = this.getTypeClass();
            Object object = clazz.newInstance();
            while (reader.hasMoreAttributeReaders()) {
                childReader = reader.getNextAttributeReader();
                name = childReader.getName();
                type = info.getType(name);
                if (type == null) continue;
                Object writeObj = type.readObject(childReader, context);
                this.writeProperty(name, object, writeObj);
            }
            while (reader.hasMoreElementReaders()) {
                childReader = reader.getNextElementReader();
                name = childReader.getName();
                type = info.getType(name);
                if (type != null) {
                    boolean nil = false;
                    MessageReader nilReader = childReader.getAttributeReader(XSI_NIL);
                    if (nilReader != null) {
                        nil = Boolean.valueOf(nilReader.getValue());
                    }
                    if (!nil) {
                        Object writeObj = type.readObject(childReader, context);
                        this.writeProperty(name, object, writeObj);
                        continue;
                    }
                    if (!info.isNillable(name)) {
                        throw new XFireFault(name.getLocalPart() + " is nil, but not nillable.", "Sender");
                    }
                    this.readToEnd(childReader);
                    continue;
                }
                this.readToEnd(childReader);
            }
            return object;
        }
        catch (IllegalAccessException e) {
            throw new XFireFault("Illegal access. " + e.getMessage(), e, "Receiver");
        }
        catch (InstantiationException e) {
            throw new XFireFault("Couldn't instantiate class. " + e.getMessage(), e, "Sender");
        }
    }

    private void readToEnd(MessageReader childReader) {
        while (childReader.hasMoreElementReaders()) {
            this.readToEnd(childReader.getNextElementReader());
        }
    }

    protected void writeProperty(QName name, Object object, Object property) throws XFireFault {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptorFromMappedName(name);
            Method m = desc.getWriteMethod();
            if (m == null) {
                throw new XFireFault("No write method for property " + name + " in " + object.getClass(), "Sender");
            }
            m.invoke(object, property);
        }
        catch (Exception e) {
            throw new XFireFault("Couldn't set property " + name + " on " + object + ". " + e.getMessage(), e, "Sender");
        }
    }

    public void writeObject(Object object, MessageWriter writer, MessageContext context) throws XFireFault {
        MessageWriter cwriter;
        Type type;
        Object value;
        QName name;
        if (object == null) {
            return;
        }
        BeanTypeInfo info = this.getTypeInfo();
        Iterator itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            value = this.readProperty(object, name);
            if (value == null) continue;
            type = this.getType(info, name);
            if (type == null) {
                throw new XFireRuntimeException("Couldn't find type for " + value.getClass() + " for property " + name);
            }
            cwriter = writer.getAttributeWriter(name);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        }
        itr = info.getElements();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            value = this.readProperty(object, name);
            type = this.getType(info, name);
            if (value != null) {
                cwriter = this.getWriter(writer, name, type);
                if (type == null) {
                    throw new XFireRuntimeException("Couldn't find type for " + value.getClass() + " for property " + name);
                }
                type.writeObject(value, cwriter, context);
                cwriter.close();
                continue;
            }
            if (!info.isNillable(name)) continue;
            cwriter = this.getWriter(writer, name, type);
            MessageWriter attWriter = cwriter.getAttributeWriter("nil", "http://www.w3.org/2001/XMLSchema-instance");
            attWriter.writeValue("true");
            attWriter.close();
            cwriter.close();
        }
    }

    private MessageWriter getWriter(MessageWriter writer, QName name, Type type) {
        MessageWriter cwriter = type.isAbstract() ? writer.getElementWriter(name) : writer.getElementWriter(name);
        return cwriter;
    }

    protected Object readProperty(Object object, QName name) {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptorFromMappedName(name);
            Method m = desc.getReadMethod();
            if (m == null) {
                throw new XFireFault("No read method for property " + name + " in class " + object.getClass().getName(), "Sender");
            }
            return m.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't get property " + name + " from bean " + object, e);
        }
    }

    public void writeSchema(Element root) {
        String prefix;
        String nameWithPrefix;
        String nameNS;
        Type type;
        Element element;
        QName name;
        BeanTypeInfo info = this.getTypeInfo();
        Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent((Content)complex);
        Element seq = null;
        Iterator itr = info.getElements();
        while (itr.hasNext()) {
            if (seq == null) {
                seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
                complex.addContent((Content)seq);
            }
            name = (QName)itr.next();
            element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
            seq.addContent((Content)element);
            type = this.getType(info, name);
            nameNS = name.getNamespaceURI();
            nameWithPrefix = name.getLocalPart();
            if (!nameNS.equals(this.getSchemaType().getNamespaceURI())) {
                nameWithPrefix = NamespaceHelper.getUniquePrefix((Element)root.getParent(), nameNS) + ":" + nameWithPrefix;
            }
            prefix = NamespaceHelper.getUniquePrefix((Element)root.getParent(), type.getSchemaType().getNamespaceURI());
            this.writeTypeReference(name, nameWithPrefix, element, type, prefix);
        }
        itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            element = new Element("attribute", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.addContent((Content)element);
            type = this.getType(info, name);
            nameNS = name.getNamespaceURI();
            nameWithPrefix = name.getLocalPart();
            if (!nameNS.equals(this.getSchemaType().getNamespaceURI())) {
                nameWithPrefix = NamespaceHelper.getUniquePrefix((Element)root.getParent(), nameNS) + ":" + nameWithPrefix;
            }
            prefix = NamespaceHelper.getUniquePrefix((Element)root.getParent(), type.getSchemaType().getNamespaceURI());
            element.setAttribute(new Attribute("name", nameWithPrefix));
            element.setAttribute(new Attribute("type", prefix + ':' + type.getSchemaType().getLocalPart()));
        }
    }

    private Type getType(BeanTypeInfo info, QName name) {
        Type type = info.getType(name);
        if (type == null) {
            throw new NullPointerException("Couldn't find type for" + name + " in class " + this.getTypeClass().getName());
        }
        return type;
    }

    private void writeTypeReference(QName name, String nameWithPrefix, Element element, Type type, String prefix) {
        if (type.isAbstract()) {
            element.setAttribute(new Attribute("name", nameWithPrefix));
            element.setAttribute(new Attribute("type", prefix + ':' + type.getSchemaType().getLocalPart()));
            if (this.getTypeInfo().isNillable(name)) {
                element.setAttribute(new Attribute("nillable", "true"));
            }
        } else {
            element.setAttribute(new Attribute("ref", prefix + ':' + type.getSchemaType().getLocalPart()));
        }
    }

    public boolean isComplex() {
        return true;
    }

    public Set getDependencies() {
        QName name;
        HashSet<Type> deps = new HashSet<Type>();
        BeanTypeInfo info = this.getTypeInfo();
        Iterator itr = info.getAttributes();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            deps.add(info.getType(name));
        }
        itr = info.getElements();
        while (itr.hasNext()) {
            name = (QName)itr.next();
            deps.add(info.getType(name));
        }
        return deps;
    }

    public BeanTypeInfo getTypeInfo() {
        if (this._info == null) {
            this._info = this.createTypeInfo();
        }
        if (!this._info.isInitialized()) {
            this._info.initialize();
        }
        return this._info;
    }

    public BeanTypeInfo createTypeInfo() {
        BeanTypeInfo info = new BeanTypeInfo(this.getTypeClass(), this.getSchemaType().getNamespaceURI());
        info.setTypeMapping(this.getTypeMapping());
        return info;
    }
}

