/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.ls.DOMWriter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer
implements DOMWriter {
    protected static final boolean DEBUG = false;
    protected final NamespaceSupport fNamespaceSupport = new NamespaceSupport();
    protected final SymbolTable fSymbolTable = new SymbolTable();
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    private boolean fPreserveSpace;
    private String fEncoding;
    private String fLastEncoding;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
        this.fFeatures = new Hashtable();
        this.initFeatures();
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        try {
            String string4;
            String string5;
            Object object;
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2 == null || string2.length() == 0 ? string3 : string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl2 = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string3 == null || string3.length() == 0) {
                if (string2 == null) {
                    throw new SAXException("No rawName and localName is null");
                }
                string3 = string != null && !string.equals("") ? ((object = this.getPrefix(string)) != null && ((String)object).length() > 0 ? (String)object + ":" + string2 : string2) : string2;
                bl = true;
            }
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string5 = attributes.getQName(n);
                    if (string5 != null && string5.length() == 0) {
                        string5 = attributes.getLocalName(n);
                        String string6 = attributes.getURI(n);
                        if (!(string6 == null || string6.length() == 0 || string != null && string.length() != 0 && string6.equals(string) || (object = this.getPrefix(string6)) == null || ((String)object).length() <= 0)) {
                            string5 = (String)object + ":" + string5;
                        }
                    }
                    if ((string4 = attributes.getValue(n)) == null) {
                        string4 = "";
                    }
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    if (string5.equals("xml:space")) {
                        bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object = this._prefixes.keys();
                while (object.hasMoreElements()) {
                    this._printer.printSpace();
                    string4 = (String)object.nextElement();
                    string5 = (String)this._prefixes.get(string4);
                    if (string5.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string, string2, string3, bl2);
            string5 = string2 == null || string2.length() == 0 ? string3 : string + "^" + string2;
            elementState.doCData = this._format.isCDataElement(string5);
            elementState.unescaped = this._format.isNonEscapingElement(string5);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementIO(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string, String string2, String string3) throws IOException {
        this.fNamespaceSupport.popContext();
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string2 = attributeList.getName(n);
                    String string3 = attributeList.getValue(n);
                    if (string3 != null) {
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this.printEscaped(string3);
                        this._printer.printText('\"');
                    }
                    if (string2.equals("xml:space")) {
                        bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) throws IOException {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                if (this._format.getEncoding() != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(this._format.getEncoding());
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string2 != null && string2.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string2, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string2 != null && string2.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element element) throws IOException {
        ElementState elementState;
        String string;
        block50: {
            int n;
            int n2;
            this.fNamespaceSupport.pushContext();
            string = element.getTagName();
            elementState = this.getElementState();
            if (this.isDocumentState()) {
                boolean bl = this.fDOML1 = element.getLocalName() == null;
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            this.fPreserveSpace = elementState.preserveSpace;
            NamedNodeMap namedNodeMap = element.getAttributes();
            boolean bl = false;
            String string2 = element.getNamespaceURI();
            String string3 = element.getPrefix();
            if (string2 != null && string3 != null && string2.length() == 0 && string3.length() != 0) {
                this._printer.printText('<');
                this._printer.printText(element.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(string);
                this._printer.indent();
            }
            if (string2 != null) {
                string2 = this.fSymbolTable.addSymbol(string2);
                String string4 = string3 = string3 == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(string3);
                if (this.fNamespaceSupport.getURI(string3) != string2) {
                    if (string2 == this.fEmptySymbol && string3 != this.fEmptySymbol) {
                        string3 = this.fEmptySymbol;
                        if (this.fNamespaceSupport.getURI(string3) != null) {
                            this.printNamespaceAttr(string3, string2);
                            this.fNamespaceSupport.declarePrefix(string3, string2);
                        }
                    } else {
                        this.printNamespaceAttr(string3, string2);
                        this.fNamespaceSupport.declarePrefix(string3, string2);
                    }
                }
            } else {
                n2 = string.indexOf(58);
                if (n2 > -1) {
                    boolean bl2;
                    n = string.lastIndexOf(58);
                    if (n2 != n) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("Element's name is not a QName: " + string, (short)1);
                            bl2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fDOMErrorHandler != null) {
                        this.modifyDOMError("Element <" + string + "> does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                        bl2 = this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                } else if (this.fNamespaceSupport.getURI(this.fEmptySymbol) != null) {
                    this.printNamespaceAttr(this.fEmptySymbol, this.fEmptySymbol);
                    this.fNamespaceSupport.declarePrefix(this.fEmptySymbol, string2);
                }
            }
            if (namedNodeMap == null) break block50;
            int n3 = 0;
            while (n3 < namedNodeMap.getLength()) {
                block52: {
                    String string5;
                    String string6;
                    Attr attr;
                    block53: {
                        block54: {
                            block51: {
                                attr = (Attr)namedNodeMap.item(n3);
                                string6 = attr.getValue();
                                string5 = attr.getNodeName();
                                string2 = attr.getNamespaceURI();
                                if (string2 == null) break block51;
                                string3 = attr.getPrefix();
                                string3 = string3 == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(string3);
                                String string7 = this.fSymbolTable.addSymbol(attr.getLocalName());
                                string2 = this.fSymbolTable.addSymbol(string2);
                                String string8 = this.fNamespaceSupport.getURI(string3);
                                if (string3 == this.fXmlnsSymbol) {
                                    if (this.fNamespaceSupport.getURI(string7) == null) {
                                        this.printNamespaceAttr(string7, string6);
                                        this.fNamespaceSupport.declarePrefix(string7, string6);
                                    }
                                } else if (string7 == this.fXmlnsSymbol && string3 == this.fEmptySymbol) {
                                    if (this.fNamespaceSupport.getURI(this.fEmptySymbol) == null) {
                                        this.printNamespaceAttr(this.fEmptySymbol, string6);
                                        this.fNamespaceSupport.declarePrefix(this.fEmptySymbol, string6);
                                    }
                                } else {
                                    if (string3 == this.fEmptySymbol || string8 != string2) {
                                        string5 = attr.getNodeName();
                                        String string9 = this.fNamespaceSupport.getPrefix(string2);
                                        if (string9 == null || string9 == this.fEmptySymbol) {
                                            if (string3 == this.fEmptySymbol) {
                                                string3 = "NS" + this.fNamespaceCounter++;
                                            }
                                            this.printNamespaceAttr(string3, string2);
                                            this.fNamespaceSupport.declarePrefix(string3, string2);
                                        } else {
                                            string3 = string9;
                                        }
                                        string5 = string3 + ":" + string7;
                                    }
                                    this.printAttribute(string5, string6 == null ? this.fEmptySymbol : string6, attr.getSpecified());
                                }
                                break block52;
                            }
                            string5 = attr.getNodeName();
                            n2 = string5.indexOf(58);
                            n = string5.lastIndexOf(58);
                            string6 = attr.getValue();
                            if (!string5.startsWith(this.fXmlnsSymbol)) break block53;
                            if (n2 >= 0) break block54;
                            if (this.fNamespaceSupport.getURI(this.fEmptySymbol) != null) break block52;
                            this.fNamespaceSupport.declarePrefix(this.fEmptySymbol, string6 == null ? this.fEmptySymbol : string6);
                            break block53;
                        }
                        if (n2 == n) {
                            string3 = string5.substring(6);
                            if (string3.length() == 0) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Namespace declaration syntax is incorrect " + string5, (short)1);
                                    boolean bl3 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (string6 != null && string6.length() == 0) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Namespace declaration syntax is incorrect " + string5, (short)1);
                                    boolean bl4 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fNamespaceSupport.getURI(string3) == null) {
                                this.fNamespaceSupport.declarePrefix(string3, string6);
                            }
                        }
                    }
                    if (n2 > -1) {
                        if (n2 != n) {
                            if (this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Attribute's name is not a QName: " + string5, (short)1);
                                boolean bl5 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                        } else if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("Attribute '" + string5 + "' does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                            boolean bl6 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        }
                        this.printAttribute(string5, string6 == null ? this.fEmptySymbol : string6, attr.getSpecified());
                    } else {
                        this.printAttribute(string5, string6 == null ? this.fEmptySymbol : string6, attr.getSpecified());
                    }
                }
                ++n3;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string, this.fPreserveSpace);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElementIO(null, null, string);
        } else {
            this.fNamespaceSupport.popContext();
            this._printer.unindent();
            this._printer.printText("/>");
            elementState.afterElement = true;
            elementState.afterComment = false;
            elementState.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string, String string2) throws IOException {
        this._printer.printSpace();
        if (string == this.fEmptySymbol) {
            this._printer.printText(this.fXmlnsSymbol);
        } else {
            this._printer.printText(this.fXmlnsSymbol + ":" + string);
        }
        this._printer.printText("=\"");
        this.printEscaped(string2);
        this._printer.printText('\"');
    }

    private void printAttribute(String string, String string2, boolean bl) throws IOException {
        if (bl || !this.getFeature("discard-default-content")) {
            this._printer.printSpace();
            this._printer.printText(string);
            this._printer.printText("=\"");
            this.printEscaped(string2);
            this._printer.printText('\"');
        }
        if (string.equals("xml:space")) {
            this.fPreserveSpace = string2.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = attributesImpl.getQName(n2);
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string.charAt(5) == ':') {
                    this.startPrefixMapping(string.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    private void initFeatures() {
        this.fFeatures.put("normalize-characters", new Boolean(false));
        this.fFeatures.put("split-cdata-sections", new Boolean(true));
        this.fFeatures.put("validation", new Boolean(false));
        this.fFeatures.put("expand-entity-references", new Boolean(false));
        this.fFeatures.put("whitespace-in-element-content", new Boolean(true));
        this.fFeatures.put("discard-default-content", new Boolean(true));
        this.fFeatures.put("format-canonical", new Boolean(false));
        this.fFeatures.put("format-pretty-print", new Boolean(false));
    }

    private void checkAllFeatures() {
        if (this.getFeature("whitespace-in-element-content")) {
            this._format.setPreserveSpace(true);
        } else {
            this._format.setPreserveSpace(false);
        }
    }

    public void setFeature(String string, boolean bl) throws DOMException {
        if (string != null && this.fFeatures.containsKey(string)) {
            if (!this.canSetFeature(string, bl)) {
                throw new DOMException(9, "Feature " + string + " cannot be set as " + bl);
            }
        } else {
            throw new DOMException(8, "Feature " + string + " not found");
        }
        this.fFeatures.put(string, new Boolean(bl));
    }

    public boolean canSetFeature(String string, boolean bl) {
        if (string.equals("normalize-characters") && bl) {
            return false;
        }
        if (string.equals("validation") && bl) {
            return false;
        }
        if (string.equals("whitespace-in-element-content") && !bl) {
            return false;
        }
        if (string.equals("format-canonical") && bl) {
            return false;
        }
        return !string.equals("format-pretty-print") || !bl;
    }

    public boolean getFeature(String string) throws DOMException {
        Boolean bl = (Boolean)this.fFeatures.get(string);
        if (bl == null) {
            throw new DOMException(8, "Feature " + string + " not found");
        }
        return bl;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String string) {
        this._format.setEncoding(string);
        this.fEncoding = this._format.getEncoding();
    }

    public String getLastEncoding() {
        return this.fLastEncoding;
    }

    public String getNewLine() {
        return this._format.getLineSeparator();
    }

    public void setNewLine(String string) {
        this._format.setLineSeparator(string);
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fDOMErrorHandler = dOMErrorHandler;
    }

    public boolean writeNode(OutputStream outputStream, Node node) throws Exception {
        block7: {
            this.checkAllFeatures();
            try {
                this.setOutputByteStream(outputStream);
                if (node == null) {
                    return false;
                }
                if (node.getNodeType() == 9) {
                    this.serialize((Document)node);
                    break block7;
                }
                if (node.getNodeType() == 11) {
                    this.serialize((DocumentFragment)node);
                    break block7;
                }
                if (node.getNodeType() == 1) {
                    this.serialize((Element)node);
                    break block7;
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
        }
        this.fLastEncoding = this.getEncoding();
        return true;
    }

    public String writeToString(Node node) throws DOMException {
        StringWriter stringWriter;
        block6: {
            this.checkAllFeatures();
            stringWriter = new StringWriter();
            try {
                this.setOutputCharStream(stringWriter);
                if (node == null) {
                    return null;
                }
                if (node.getNodeType() == 9) {
                    this.serialize((Document)node);
                    break block6;
                }
                if (node.getNodeType() == 11) {
                    this.serialize((DocumentFragment)node);
                    break block6;
                }
                if (node.getNodeType() == 1) {
                    this.serialize((Element)node);
                    break block6;
                }
                return null;
            }
            catch (IOException iOException) {
                throw new DOMException(2, "The resulting string is too long to fit in a DOMString: " + iOException.getMessage());
            }
        }
        this.fLastEncoding = this.getEncoding();
        return stringWriter.toString();
    }

    public boolean reset() {
        super.reset();
        this.fNamespaceSupport.reset(this.fSymbolTable);
        this.fNamespaceCounter = 1;
        this.fXmlSymbol = this.fSymbolTable.addSymbol("xml");
        this.fXmlnsSymbol = this.fSymbolTable.addSymbol("xmlns");
        this.fEmptySymbol = this.fSymbolTable.addSymbol("");
        return true;
    }
}

