/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.impl.validation.XMLGrammarPoolImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;

public class CachingParserPool {
    public static final boolean DEFAULT_SHADOW_SYMBOL_TABLE = false;
    public static final boolean DEFAULT_SHADOW_GRAMMAR_POOL = false;
    protected SymbolTable fSynchronizedSymbolTable;
    protected XMLGrammarPool fSynchronizedGrammarPool;
    protected boolean fShadowSymbolTable = false;
    protected boolean fShadowGrammarPool = false;

    public CachingParserPool() {
        this(new SymbolTable(), new XMLGrammarPoolImpl());
    }

    public CachingParserPool(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this.fSynchronizedSymbolTable = new SynchronizedSymbolTable(symbolTable);
        this.fSynchronizedGrammarPool = new SynchronizedGrammarPool(xMLGrammarPool);
    }

    public SymbolTable getSymbolTable() {
        return this.fSynchronizedSymbolTable;
    }

    public XMLGrammarPool getXMLGrammarPool() {
        return this.fSynchronizedGrammarPool;
    }

    public void setShadowSymbolTable(boolean bl) {
        this.fShadowSymbolTable = bl;
    }

    public DOMParser createDOMParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        XMLGrammarPool xMLGrammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new DOMParser(symbolTable, xMLGrammarPool);
    }

    public SAXParser createSAXParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        XMLGrammarPool xMLGrammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new SAXParser(symbolTable, xMLGrammarPool);
    }

    public static final class ShadowedGrammarPool
    extends XMLGrammarPoolImpl {
        private XMLGrammarPool fGrammarPool;

        public ShadowedGrammarPool(XMLGrammarPool xMLGrammarPool) {
            this.fGrammarPool = xMLGrammarPool;
        }

        public Grammar[] retrieveInitialGrammarSet(String string) {
            Grammar[] grammarArray = super.retrieveInitialGrammarSet(string);
            if (grammarArray != null) {
                return grammarArray;
            }
            return this.fGrammarPool.retrieveInitialGrammarSet(string);
        }

        public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
            Grammar grammar = super.retrieveGrammar(xMLGrammarDescription);
            if (grammar != null) {
                return grammar;
            }
            return this.fGrammarPool.retrieveGrammar(xMLGrammarDescription);
        }

        public void cacheGrammars(String string, Grammar[] grammarArray) {
            super.cacheGrammars(string, grammarArray);
            this.fGrammarPool.cacheGrammars(string, grammarArray);
        }

        public Grammar getGrammar(String string) {
            if (super.containsGrammar(string)) {
                return super.getGrammar(string);
            }
            return null;
        }

        public boolean containsGrammar(String string) {
            return super.containsGrammar(string);
        }
    }

    public static final class SynchronizedGrammarPool
    implements XMLGrammarPool {
        private XMLGrammarPool fGrammarPool;

        public SynchronizedGrammarPool(XMLGrammarPool xMLGrammarPool) {
            this.fGrammarPool = xMLGrammarPool;
        }

        public Grammar[] retrieveInitialGrammarSet(String string) {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                Grammar[] grammarArray = this.fGrammarPool.retrieveInitialGrammarSet(string);
                return grammarArray;
            }
        }

        public Grammar retrieveGrammar(XMLGrammarDescription xMLGrammarDescription) {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                Grammar grammar = this.fGrammarPool.retrieveGrammar(xMLGrammarDescription);
                return grammar;
            }
        }

        public void cacheGrammars(String string, Grammar[] grammarArray) {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                this.fGrammarPool.cacheGrammars(string, grammarArray);
            }
        }
    }

    public static final class ShadowedSymbolTable
    extends SymbolTable {
        protected SymbolTable fSymbolTable;

        public ShadowedSymbolTable(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        public String addSymbol(String string) {
            if (this.fSymbolTable.containsSymbol(string)) {
                return this.fSymbolTable.addSymbol(string);
            }
            return super.addSymbol(string);
        }

        public String addSymbol(char[] cArray, int n, int n2) {
            if (this.fSymbolTable.containsSymbol(cArray, n, n2)) {
                return this.fSymbolTable.addSymbol(cArray, n, n2);
            }
            return super.addSymbol(cArray, n, n2);
        }

        public int hash(String string) {
            return this.fSymbolTable.hash(string);
        }

        public int hash(char[] cArray, int n, int n2) {
            return this.fSymbolTable.hash(cArray, n, n2);
        }
    }

    public static final class SynchronizedSymbolTable
    extends SymbolTable {
        protected SymbolTable fSymbolTable;

        public SynchronizedSymbolTable(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        public String addSymbol(String string) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                String string2 = this.fSymbolTable.addSymbol(string);
                return string2;
            }
        }

        public String addSymbol(char[] cArray, int n, int n2) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                String string = this.fSymbolTable.addSymbol(cArray, n, n2);
                return string;
            }
        }

        public boolean containsSymbol(String string) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                boolean bl = this.fSymbolTable.containsSymbol(string);
                return bl;
            }
        }

        public boolean containsSymbol(char[] cArray, int n, int n2) {
            SymbolTable symbolTable = this.fSymbolTable;
            synchronized (symbolTable) {
                boolean bl = this.fSymbolTable.containsSymbol(cArray, n, n2);
                return bl;
            }
        }
    }
}

