/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.dom.SOAPElement;
import org.apache.axiom.soap.impl.dom.factory.DOMSOAPFactory;

public class SOAPEnvelopeImpl
extends SOAPElement
implements SOAPEnvelope,
OMConstants {
    public SOAPEnvelopeImpl(OMXMLParserWrapper builder, SOAPFactory factory) {
        super(null, "Envelope", builder, factory);
    }

    public SOAPEnvelopeImpl(DocumentImpl doc, OMXMLParserWrapper builder, SOAPFactory factory) {
        super(doc, "Envelope", null, builder, factory);
    }

    public SOAPEnvelopeImpl(OMNamespace ns, SOAPFactory factory) {
        super(((DOMSOAPFactory)factory).getDocument(), "Envelope", ns, factory);
        this.getOwnerDocument().appendChild(this);
    }

    public SOAPHeader getHeader() throws OMException {
        return (SOAPHeader)this.getFirstChildWithName(new QName("Header"));
    }

    public void addChild(OMNode child) {
        if (child instanceof OMElement && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPProcessingException("SOAP Envelope can not have children other than SOAP Header and Body", "Sender");
        }
        super.addChild(child);
    }

    public SOAPBody getBody() throws OMException {
        OMElement element = this.getFirstElement();
        if (element != null) {
            OMNode node;
            if ("Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            for (node = element.getNextOMSibling(); node != null && node.getType() != 1; node = node.getNextOMSibling()) {
            }
            element = (OMElement)node;
            if (node != null && "Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
        }
        return null;
    }

    public OMNode detach() throws OMException {
        throw new OMException("Root Element can not be detached");
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
    }

    protected void internalSerialize(XMLStreamWriter writer2, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter writer = (MTOMXMLStreamWriter)writer2;
        if (!writer.isIgnoreXMLDeclaration()) {
            String charSetEncoding = writer.getCharSetEncoding();
            String xmlVersion = writer.getXmlVersion();
            writer.getXmlStreamWriter().writeStartDocument(charSetEncoding == null ? "utf-8" : charSetEncoding, xmlVersion == null ? "1.0" : xmlVersion);
        }
        super.internalSerialize(writer, cache);
    }

    public OMNode getNextOMSibling() throws OMException {
        if (this.ownerNode != null && !this.ownerNode.isComplete()) {
            this.ownerNode.setComplete(true);
        }
        return null;
    }
}

