/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.DOMMessageFormatter;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class NodeImpl
implements Node,
NodeList,
OMNodeEx,
Cloneable {
    private Map userData = new Hashtable();
    protected OMXMLParserWrapper builder;
    protected boolean done = false;
    protected int nodeType;
    protected DocumentImpl ownerNode;
    protected OMFactory factory;
    protected short flags;
    protected static final short OWNED = 2;
    protected static final short FIRSTCHILD = 4;
    protected static final short READONLY = 8;
    protected static final short SPECIFIED = 16;
    protected static final short NORMALIZED = 32;

    protected NodeImpl(DocumentImpl ownerDocument, OMFactory factory) {
        this(factory);
        this.ownerNode = ownerDocument;
    }

    protected NodeImpl(OMFactory factory) {
        this.factory = factory;
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setNodeValue(String arg0) throws DOMException {
    }

    public void setPrefix(String prefix) throws DOMException {
        throw new DOMException(14, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NAMESPACE_ERR", null));
    }

    public Document getOwnerDocument() {
        return this.ownerNode;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    NodeImpl parentNode() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public Node cloneNode(boolean deep) {
        NodeImpl newnode;
        try {
            newnode = (NodeImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("**Internal Error**" + e);
        }
        newnode.ownerNode = this.ownerNode;
        newnode.isOwned(false);
        newnode.isReadonly(false);
        return newnode;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public boolean isSupported(String feature, String version) {
        throw new UnsupportedOperationException();
    }

    public Node appendChild(Node newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(8, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null));
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public int getLength() {
        return 0;
    }

    public Node item(int index) {
        return null;
    }

    final boolean isOwned() {
        return (this.flags & 2) != 0;
    }

    final void isOwned(boolean value) {
        this.flags = (short)(value ? this.flags | 2 : this.flags & 0xFFFFFFFD);
    }

    final boolean isFirstChild() {
        return (this.flags & 4) != 0;
    }

    final void isFirstChild(boolean value) {
        this.flags = (short)(value ? this.flags | 4 : this.flags & 0xFFFFFFFB);
    }

    final boolean isReadonly() {
        return (this.flags & 8) != 0;
    }

    final void isReadonly(boolean value) {
        this.flags = (short)(value ? this.flags | 8 : this.flags & 0xFFFFFFF7);
    }

    final boolean isSpecified() {
        return (this.flags & 0x10) != 0;
    }

    final void isSpecified(boolean value) {
        this.flags = (short)(value ? this.flags | 0x10 : this.flags & 0xFFFFFFEF);
    }

    final boolean isNormalized() {
        return (this.flags & 0x20) != 0;
    }

    final void isNormalized(boolean value) {
        if (!value && this.isNormalized() && this.ownerNode != null) {
            this.ownerNode.isNormalized(false);
        }
        this.flags = (short)(value ? this.flags | 0x20 : this.flags & 0xFFFFFFDF);
    }

    public OMContainer getParent() throws OMException {
        return null;
    }

    public boolean isComplete() {
        return this.done;
    }

    public void setComplete(boolean state) {
        this.done = state;
    }

    public void internalSerializeWithCache(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer);
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public OMNode getPreviousOMSibling() {
        return null;
    }

    public OMNode getNextOMSibling() {
        return null;
    }

    public void setPreviousOMSibling(OMNode previousSibling) {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public void setNextOMSibling(OMNode previousSibling) {
        throw new DOMException(3, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null));
    }

    public void build() {
        while (!this.done) {
            this.builder.next();
        }
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
    }

    protected void setOwnerDocument(DocumentImpl document) {
        this.ownerNode = document;
        this.isOwned(true);
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerialize(writer);
        writer.flush();
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }

    public OMNode detach() {
        throw new OMException("Elements that doesn't have a parent can not be detached");
    }

    public String getBaseURI() {
        throw new UnsupportedOperationException("TODO");
    }

    public short compareDocumentPosition(Node arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public void setTextContent(String arg0) throws DOMException {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isSameNode(Node arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public String lookupPrefix(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isDefaultNamespace(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public String lookupNamespaceURI(String arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isEqualNode(Node arg0) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object getFeature(String arg0, String arg1) {
        throw new UnsupportedOperationException("TODO");
    }

    public Object setUserData(String key, Object value, UserDataHandler userDataHandler) {
        return this.userData.put(key, value);
    }

    public Object getUserData(String key) {
        return this.userData.get(key);
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        this.serialize(StAXUtils.createXMLStreamWriter(output));
    }

    public void serialize(Writer writer) throws XMLStreamException {
        this.serialize(StAXUtils.createXMLStreamWriter(writer));
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(StAXUtils.createXMLStreamWriter(output));
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        this.serializeAndConsume(StAXUtils.createXMLStreamWriter(writer));
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerialize(writer);
        writer.flush();
    }

    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer2));
        writer.setOutputFormat(format);
        this.internalSerialize(writer);
        writer.flush();
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format);
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }

    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter(writer2));
        writer.setOutputFormat(format);
        this.internalSerializeAndConsume(writer);
        writer.flush();
    }

    public OMFactory getOMFactory() {
        return this.factory;
    }
}

