/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.DataUtil;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;

final class NonNsAttributeCollector
extends AttributeCollector {
    protected static final String DEFAULT_NS_URI = null;
    protected static final String DEFAULT_PREFIX = null;

    protected NonNsAttributeCollector(boolean normAttrs) {
        super(normAttrs);
    }

    protected void reset() {
        this.mValueBuffer.reset();
        this.mAttrNames.clear(false);
        this.mAttrCount = 0;
    }

    protected void resolveValues(InputProblemReporter rep) throws WstxException {
        int hashCount;
        int attrCount;
        this.mNonDefCount = attrCount = this.mAttrCount;
        if (attrCount < 1) {
            this.mAttrHashSize = 0;
        }
        String[] attrNames = this.mAttrNames.getInternalArray();
        if (this.mAttrValues != null) {
            if (this.mAttrValues.length < attrCount) {
                this.mAttrValues = null;
            } else {
                for (int i = 0; i < attrCount; ++i) {
                    this.mAttrValues[i] = null;
                }
            }
        }
        int[] map = this.mAttrMap;
        int min = attrCount + (attrCount >> 2);
        for (hashCount = 4; hashCount < min; hashCount += hashCount) {
        }
        this.mAttrHashSize = hashCount;
        min = hashCount + (hashCount >> 4);
        if (map == null || map.length < min) {
            map = new int[min];
        } else {
            for (int i = 0; i < hashCount; ++i) {
                map[i] = 0;
            }
        }
        int mask = hashCount - 1;
        int spillIndex = hashCount;
        for (int i = 0; i < attrCount; ++i) {
            String name = attrNames[i];
            int hash = name.hashCode();
            int index = hash & mask;
            if (map[index] == 0) {
                map[index] = i + 1;
                continue;
            }
            int currIndex = map[index] - 1;
            if ((map = this.spillAttr(name, map, currIndex, spillIndex, attrCount, hash, hashCount)) == null) {
                this.throwDupAttr(rep, currIndex);
            }
            map[++spillIndex] = i;
            ++spillIndex;
        }
        this.mAttrSpillEnd = spillIndex;
        this.mAttrMap = map;
    }

    public int getNsCount() {
        return 0;
    }

    public String getNsPrefix(int index) {
        return DEFAULT_PREFIX;
    }

    public String getNsURI(int index) {
        return DEFAULT_NS_URI;
    }

    public String getPrefix(int index) {
        if (index < 0 || index >= this.mAttrCount) {
            this.throwIndex(index);
        }
        return DEFAULT_PREFIX;
    }

    public String getLocalName(int index) {
        if (index < 0 || index >= this.mAttrCount) {
            this.throwIndex(index);
        }
        return this.mAttrNames.getString(index);
    }

    public String getURI(int index) {
        if (index < 0 || index >= this.mAttrCount) {
            this.throwIndex(index);
        }
        return DEFAULT_NS_URI;
    }

    public QName getQName(int index) {
        return new QName(this.getLocalName(index));
    }

    public String getValue(String nsURI, String localName) {
        String thisName;
        if (nsURI != null && nsURI.length() > 0) {
            return null;
        }
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return null;
        }
        int hash = localName.hashCode();
        int ix = this.mAttrMap[hash & hashSize - 1];
        if (ix == 0) {
            return null;
        }
        if ((thisName = this.mAttrNames.getString(--ix)) == localName || thisName.equals(localName)) {
            return this.getValue(ix);
        }
        int len = this.mAttrSpillEnd;
        for (int i = hashSize; i < len; i += 2) {
            if (this.mAttrMap[i] != hash || (thisName = this.mAttrNames.getString(ix = this.mAttrMap[i + 1])) != localName && !thisName.equals(localName)) continue;
            return this.getValue(ix);
        }
        return null;
    }

    public int findIndex(String localName) {
        String thisName;
        int hashSize = this.mAttrHashSize;
        if (hashSize == 0) {
            return -1;
        }
        int hash = localName.hashCode();
        int ix = this.mAttrMap[hash & hashSize - 1];
        if (ix == 0) {
            return -1;
        }
        if ((thisName = this.mAttrNames.getString(--ix)) == localName || thisName.equals(localName)) {
            return ix;
        }
        int len = this.mAttrSpillEnd;
        for (int i = hashSize; i < len; i += 2) {
            if (this.mAttrMap[i] != hash || (thisName = this.mAttrNames.getString(ix = this.mAttrMap[i + 1])) != localName && !thisName.equals(localName)) continue;
            return ix;
        }
        return -1;
    }

    public TextBuilder getDefaultNsBuilder() {
        this.throwInternal();
        return null;
    }

    public TextBuilder getNsBuilder(String localName) {
        this.throwInternal();
        return null;
    }

    public TextBuilder getAttrBuilder(String attrPrefix, String attrLocalName) {
        ++this.mAttrCount;
        this.mAttrNames.addString(attrLocalName);
        return this.mValueBuffer;
    }

    public TextBuilder getNsURIs() {
        this.throwInternal();
        return null;
    }

    public ElemAttrs buildAttrOb() {
        int count = this.mAttrCount;
        if (count == 0) {
            return null;
        }
        String[] raw = new String[count << 2];
        for (int i = 0; i < count; ++i) {
            int ix = i << 2;
            raw[ix] = this.mAttrNames.getString(i);
            raw[ix + 1] = DEFAULT_NS_URI;
            raw[ix + 2] = DEFAULT_PREFIX;
            raw[ix + 3] = this.getValue(i);
        }
        if (count < 4) {
            return new ElemAttrs(raw, this.mNonDefCount);
        }
        return new ElemAttrs(raw, this.mNonDefCount, this.mAttrMap, this.mAttrHashSize, this.mAttrSpillEnd);
    }

    public void addDefaultAttr(InputProblemReporter rep, StringVector ns, String prefix, String localName, String value) {
        this.mAttrNames.addString(localName);
        int attrIndex = this.mAttrCount;
        if (this.mAttrValues == null) {
            this.mAttrValues = new String[attrIndex + 8];
        } else if (attrIndex >= this.mAttrValues.length) {
            this.mAttrValues = DataUtil.growArrayBy(this.mAttrValues, 8);
        }
        this.mAttrValues[attrIndex] = value;
        int hash = localName.hashCode();
        int index = hash & this.mAttrHashSize - 1;
        int[] map = this.mAttrMap;
        if (map[index] == 0) {
            map[index] = attrIndex + 1;
        } else {
            if (this.mAttrSpillEnd + 1 >= map.length) {
                this.mAttrMap = map = DataUtil.growArrayBy(map, 8);
            }
            map[this.mAttrSpillEnd] = hash;
            map[this.mAttrSpillEnd + 1] = attrIndex;
            this.mAttrSpillEnd += 2;
        }
        ++this.mAttrCount;
    }

    public void writeAttribute(int index, char quoteChar, Writer mainWriter, Writer attrValueWriter) throws IOException {
        mainWriter.write(this.mAttrNames.getString(index));
        mainWriter.write(61);
        mainWriter.write(quoteChar);
        this.writeValue(index, attrValueWriter);
        mainWriter.write(quoteChar);
    }

    private void throwInternal() {
        throw new Error("Internal error: shouldn't call this method.");
    }

    private int[] spillAttr(String name, int[] map, int currIndex, int spillIndex, int attrCount, int hash, int hashCount) {
        if (this.mAttrNames.getString(currIndex) == name) {
            return null;
        }
        if (spillIndex + 1 >= map.length) {
            map = DataUtil.growArrayBy(map, 8);
        }
        for (int j = hashCount; j < spillIndex; j += 2) {
            if (map[j] != hash || this.mAttrNames.getString(currIndex = map[j + 1]) != name) continue;
            return null;
        }
        map[spillIndex] = hash;
        return map;
    }
}

