/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.WordResolver;

public final class DTDEnumAttr
extends DTDAttribute {
    final WordResolver mEnumValues;

    public DTDEnumAttr(NameKey name, int defValueType, String defValue, int specIndex, WordResolver enumValues) {
        super(name, defValueType, defValue, specIndex);
        this.mEnumValues = enumValues;
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDEnumAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex, this.mEnumValues);
    }

    public int getValueType() {
        return 1;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        String ok = ac.checkEnumValue(index, this.mEnumValues);
        if (ok == null) {
            String val = ac.getValue(index);
            this.reportParseError(v, "Invalid value '" + val + "': has to be one of (" + this.mEnumValues + ")");
        }
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        String def = this.validateDefaultNmToken(rep, normalize);
        String shared = this.mEnumValues.find(def);
        if (shared == null) {
            this.reportParseError(rep, "Invalid default value '" + def + "': has to be one of (" + this.mEnumValues + ")");
        }
        if (normalize) {
            this.mDefValue = shared;
        }
    }
}

