/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.ServletContextPropertyUtils;
import org.springframework.web.util.WebUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wang.moshu.smvc.framework.util.StringUtil;

public class XMLParser {
    public <T> T parseXml2Object(ServletContext servletContext, String filePath, Class<T> clazz) {
        return XMLParser.parseXml2Object(servletContext, filePath, clazz, new HashMap<String, String>());
    }

    public static <T> T parseXml2Object(ServletContext servletContext, String filePath, Class<T> clazz, Map<String, String> nodeName2FieldMap) {
        T result = null;
        try {
            Element root;
            String location = ServletContextPropertyUtils.resolvePlaceholders((String)filePath, (ServletContext)servletContext);
            if (!ResourceUtils.isUrl((String)location)) {
                location = WebUtils.getRealPath((ServletContext)servletContext, (String)location);
            }
            servletContext.log("Initializing smvc from [" + location + "]");
            String resolvedLocation = SystemPropertyUtils.resolvePlaceholders((String)location);
            File file = ResourceUtils.getFile((String)resolvedLocation);
            if (!file.exists()) {
                throw new FileNotFoundException("Log4j config file [" + resolvedLocation + "] not found");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file);
            String className = clazz.getSimpleName();
            if (!className.equals((root = document.getDocumentElement()).getNodeName()) && !nodeName2FieldMap.containsKey(root.getNodeName())) {
                return result;
            }
            if (null != root) {
                result = clazz.newInstance();
                for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    String nodeName = node.getNodeName();
                    String nodeValue = node.getFirstChild().getNodeValue();
                    if (StringUtil.isEmpty(nodeName) || StringUtil.isEmpty(nodeValue)) continue;
                    if (nodeName2FieldMap.containsKey(nodeName)) {
                        nodeName = nodeName2FieldMap.get(nodeName);
                    }
                    String setMethodName = "set" + StringUtil.upperFirst(nodeName);
                    Method setMethod = clazz.getDeclaredMethod(setMethodName, String.class);
                    setMethod.setAccessible(true);
                    setMethod.invoke(result, nodeValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result;
    }
}

