/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import wang.moshu.smvc.framework.util.Assert;

public class StringUtil {
    public static final String EMPTY_STRING = "";

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty() || str.trim().isEmpty();
    }

    public static String upperFirst(String str) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(str)) {
            String firstChar = str.substring(0, 1);
            sb.append(firstChar.toUpperCase()).append(str.substring(1, str.length()));
            return sb.toString();
        }
        return EMPTY_STRING;
    }

    public static String lowerFirst(String str) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(str)) {
            String firstChar = str.substring(0, 1);
            sb.append(firstChar.toLowerCase()).append(str.substring(1, str.length()));
            return sb.toString();
        }
        return EMPTY_STRING;
    }

    public static String[] standardUrlPattern(String[] urls) {
        Assert.notNull(urls);
        String[] results = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            results[i] = urls[i].startsWith("/") ? urls[i].substring(1, urls[i].length()) : urls[i];
        }
        return results;
    }

    public static String standardUrlPattern(String url) {
        Assert.notNull(url);
        String result = null;
        result = url.startsWith("/") ? url.substring(1, url.length()) : url;
        return result;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtil.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtil.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }
}

