/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import wang.moshu.smvc.framework.util.ArrayUtil;
import wang.moshu.smvc.framework.util.Assert;
import wang.moshu.smvc.framework.util.StringUtil;

public class RequestUtil {
    public static String getRealRequestURIWithoutPrefix(HttpServletRequest request) {
        String realUri = RequestUtil.getRealRequestURI(request);
        return realUri.replaceFirst("/", "");
    }

    public static String getRealRequestURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (StringUtil.isEmpty(contextPath) || "/".equals(contextPath)) {
            return requestURI;
        }
        if (StringUtil.isEmpty(requestURI)) {
            return requestURI;
        }
        if (requestURI.contains(contextPath)) {
            return requestURI.replaceFirst(contextPath, "");
        }
        return requestURI;
    }

    public static Map<String, String[]> getRequestParamMapping(HttpServletRequest request) {
        return request.getParameterMap();
    }

    public static List<String> getRequestParamStrList(HttpServletRequest request) {
        Assert.notNull(request);
        String paramsStr = request.getQueryString();
        if (StringUtils.isEmpty((Object)paramsStr)) {
            return new ArrayList<String>();
        }
        String[] params = paramsStr.split("&");
        if (ArrayUtil.isArrayEmpty(params)) {
            return Arrays.asList(params);
        }
        return new ArrayList<String>();
    }
}

