/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import java.util.Map;
import org.springframework.util.StringUtils;
import wang.moshu.smvc.framework.util.StringUtil;

public class PathUtil {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    public static final String URL_VARIATE_REGEX = "^\\{([a-zA-Z0-9_])*\\}$";
    private static final PathUtil INSTANCE = new PathUtil();
    private String pathSeparator = "/";

    public static PathUtil getInstance() {
        return INSTANCE;
    }

    public boolean match(String pattern, String path) {
        return this.doMatch(pattern, path, true, null);
    }

    public boolean matchStart(String pattern, String path) {
        return this.doMatch(pattern, path, false, null);
    }

    protected boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
        String patDir;
        int pathIdxStart;
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = StringUtil.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathDirs = StringUtil.tokenizeToStringArray(path, this.pathSeparator);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) ? path.endsWith(this.pathSeparator) : !path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
                if (pattDirs[i].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i = pattIdxStart + 1; i <= pattIdxEnd; ++i) {
                if (!pattDirs[i].equals("**")) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i + j];
                    if (!this.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i = pattIdxStart; i <= pattIdxEnd; ++i) {
            if (pattDirs[i].equals("**")) continue;
            return false;
        }
        return true;
    }

    public String combine(String pattern1, String pattern2) {
        String extension2;
        String fileName2;
        if (StringUtil.isEmpty(pattern1) && StringUtil.isEmpty(pattern2)) {
            return "";
        }
        if (StringUtil.isEmpty(pattern1)) {
            return pattern2;
        }
        if (StringUtil.isEmpty(pattern2)) {
            return pattern1;
        }
        if (!pattern1.contains("{") && this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith("/*")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1.substring(0, pattern1.length() - 1) + pattern2.substring(1);
            }
            return pattern1.substring(0, pattern1.length() - 1) + pattern2;
        }
        if (pattern1.endsWith("/**")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1 + pattern2;
            }
            return pattern1 + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        int dotPos1 = pattern1.indexOf(46);
        if (dotPos1 == -1) {
            if (pattern1.endsWith(DEFAULT_PATH_SEPARATOR) || pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1 + pattern2;
            }
            return pattern1 + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        String fileName1 = pattern1.substring(0, dotPos1);
        String extension1 = pattern1.substring(dotPos1);
        int dotPos2 = pattern2.indexOf(46);
        if (dotPos2 != -1) {
            fileName2 = pattern2.substring(0, dotPos2);
            extension2 = pattern2.substring(dotPos2);
        } else {
            fileName2 = pattern2;
            extension2 = "";
        }
        String fileName = fileName1.endsWith("*") ? fileName2 : fileName1;
        String extension = extension1.startsWith("*") ? extension2 : extension1;
        return fileName + extension;
    }

    public String combine2(String pattern1, String pattern2) {
        if (StringUtil.isEmpty(pattern1) && StringUtil.isEmpty(pattern2)) {
            return "";
        }
        if (StringUtil.isEmpty(pattern1)) {
            return pattern2;
        }
        if (StringUtil.isEmpty(pattern2)) {
            return pattern1;
        }
        if (!pattern1.contains("{") && this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith("/*")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return pattern1.substring(0, pattern1.length() - 1) + pattern2.substring(1);
            }
            return pattern1.substring(0, pattern1.length() - 1) + pattern2;
        }
        if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
            return pattern1 + pattern2.substring(0, pattern2.length() - 1);
        }
        return pattern1 + pattern2;
    }

    public boolean matchStrings(String pattern, String str) {
        if (pattern.contains("*")) {
            pattern = pattern.replace("*", ".*");
        }
        return str.matches(pattern);
    }

    public boolean matchPath(String controllerPath, String requestPath, Map<String, String> routeParams) {
        String[] paths;
        String[] toMatchPaths;
        if (controllerPath.contains("*")) {
            controllerPath = controllerPath.replace("*", ".*");
        }
        if ((toMatchPaths = requestPath.split(DEFAULT_PATH_SEPARATOR)).length != (paths = controllerPath.split(DEFAULT_PATH_SEPARATOR)).length) {
            return false;
        }
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].matches(URL_VARIATE_REGEX)) {
                String routeVar = paths[i];
                routeParams.put(routeVar.substring(1, paths[i].length() - 1), toMatchPaths[i]);
                continue;
            }
            if (toMatchPaths[i].matches(paths[i])) continue;
            return false;
        }
        return true;
    }

    public String removeLastSlash(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return str;
        }
        if (str.endsWith(DEFAULT_PATH_SEPARATOR)) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static void main(String[] args) {
        String var = "{abc1_}";
        System.out.println(var.matches(URL_VARIATE_REGEX));
    }
}

