/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import wang.moshu.smvc.framework.util.ClassUtil;

public final class MethodParamNameVisitor {
    private static Map<String, String[]> methodParamNamesCache = new HashMap<String, String[]>();

    private MethodParamNameVisitor() {
    }

    private static boolean sameType(Type[] types, Class<?>[] clazzes) {
        if (types.length != clazzes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(clazzes[i]).equals((Object)types[i])) continue;
            return false;
        }
        return true;
    }

    private static String getMethodParamString(Class<?>[] paramTypes) {
        StringBuilder sb = new StringBuilder();
        for (Class<?> paramType : paramTypes) {
            sb.append(".");
            sb.append(paramType.getName());
        }
        return sb.toString();
    }

    public static String[] getMethodParamNames(final Method m) {
        String key = m.getDeclaringClass().getName() + "." + m.getName() + MethodParamNameVisitor.getMethodParamString(m.getParameterTypes());
        if (methodParamNamesCache.containsKey(key)) {
            return methodParamNamesCache.get(key);
        }
        final String[] paramNames = new String[m.getParameterTypes().length];
        Class<?> clazz = m.getDeclaringClass();
        InputStream is = clazz.getResourceAsStream(ClassUtil.getClassFileName(clazz));
        if (is == null) {
            return null;
        }
        ClassReader reader = null;
        try {
            reader = new ClassReader(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        reader.accept(new ClassVisitor(262144){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Type[] args = Type.getArgumentTypes((String)desc);
                if (!name.equals(m.getName()) || !MethodParamNameVisitor.sameType(args, m.getParameterTypes())) {
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                MethodVisitor v = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(262144, v){

                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        int i = index - 1;
                        if (Modifier.isStatic(m.getModifiers())) {
                            i = index;
                        }
                        if (i >= 0 && i < paramNames.length) {
                            paramNames[i] = name;
                        }
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }
                };
            }
        }, 0);
        methodParamNamesCache.put(key, paramNames);
        return paramNames;
    }
}

