/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import org.springframework.util.StringUtils;
import wang.moshu.smvc.framework.exception.BusinessException;

public class Assert {
    private static final String EMAIL_REGEX = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    private static final String MOBILE_REGEX = "^1\\d{10}$";

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new BusinessException(message);
        }
        if (object instanceof String && "".equals(object)) {
            throw new BusinessException(message);
        }
    }

    public static void notNull(Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void email(String str, String message) {
        if (StringUtils.isEmpty((Object)str)) {
            return;
        }
        if (!str.matches(EMAIL_REGEX)) {
            throw new BusinessException(message);
        }
    }

    public static void mobile(String str, String message) {
        if (StringUtils.isEmpty((Object)str)) {
            return;
        }
        if (!str.matches(MOBILE_REGEX)) {
            throw new BusinessException(message);
        }
    }
}

