/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import wang.moshu.smvc.framework.util.Assert;

public class AnnotationUtil {
    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass;
        Assert.notNull(clazz, "Class must not be null");
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            annotation = AnnotationUtil.findAnnotation(ifc, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            for (Annotation ann : clazz.getAnnotations()) {
                annotation = AnnotationUtil.findAnnotation(ann.annotationType(), annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if ((superClass = clazz.getSuperclass()) == null || superClass == Object.class) {
            return null;
        }
        return AnnotationUtil.findAnnotation(superClass, annotationType);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        Assert.notNull(method, "Method must not be null");
        A annotation = method.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Field field, Class<A> annotationType) {
        Assert.notNull(field, "Method must not be null");
        A annotation = field.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return null;
    }
}

