/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.handler;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import wang.moshu.smvc.framework.annotation.RequestMapping;
import wang.moshu.smvc.framework.domain.RouteInfoHolder;
import wang.moshu.smvc.framework.domain.RouteMatchResult;
import wang.moshu.smvc.framework.interceptor.RequestInterceptor;
import wang.moshu.smvc.framework.interceptor.annotation.Clear;
import wang.moshu.smvc.framework.interceptor.annotation.Intercept;
import wang.moshu.smvc.framework.util.AnnotationUtil;
import wang.moshu.smvc.framework.util.Assert;
import wang.moshu.smvc.framework.util.PathUtil;
import wang.moshu.smvc.framework.util.RequestUtil;
import wang.moshu.smvc.framework.util.SpringBeanUtils;
import wang.moshu.smvc.framework.util.StringUtil;

public class RouteHandler {
    private static final RouteHandler INSTANCE = new RouteHandler();
    private Map<String, RouteInfoHolder> routeControls = new HashMap<String, RouteInfoHolder>();
    private Map<String, String> routeMatchCache = new HashMap<String, String>();
    private Log logger = LogFactory.getLog(RouteHandler.class);

    private RouteHandler() {
    }

    public static RouteHandler getInstance() {
        return INSTANCE;
    }

    public void registRouteByClass(Class<?> clazz) {
        Controller controller = AnnotationUtil.findAnnotation(clazz, Controller.class);
        if (controller != null) {
            RequestMapping requestMapping = AnnotationUtil.findAnnotation(clazz, RequestMapping.class);
            this.registRouteByMethod(StringUtil.standardUrlPattern(requestMapping.value()), clazz);
        }
    }

    public void registRouteByMethod(String classRoute, Class<?> clazz) {
        Method[] methods;
        Assert.notNull(clazz, "Class cannot be null.");
        String beanSpringName = StringUtils.isEmpty((Object)clazz.getAnnotation(Controller.class).value()) ? StringUtil.lowerFirst(clazz.getSimpleName()) : clazz.getAnnotation(Controller.class).value();
        Object instance = SpringBeanUtils.getBean(beanSpringName);
        Assert.notNull(instance, "Faild to get controller instance, class:" + clazz);
        Set<Class<? extends RequestInterceptor>> classInterceptors = this.loadInterceptor(clazz);
        HashMap<Method, RouteInfoHolder> results = new HashMap<Method, RouteInfoHolder>();
        for (Method method : methods = clazz.getMethods()) {
            RequestMapping requestMapping = AnnotationUtil.findAnnotation(method, RequestMapping.class);
            if (requestMapping == null) continue;
            RouteInfoHolder routeInfoHolder = new RouteInfoHolder(requestMapping.value(), requestMapping.requestDataType(), requestMapping.returnType(), method, instance);
            Set<Class<? extends RequestInterceptor>> methodInterceptors = this.loadInterceptor(method);
            methodInterceptors.addAll(classInterceptors);
            this.loadClearInterceptor(method, methodInterceptors);
            HashSet<RequestInterceptor> interceptorInstances = new HashSet<RequestInterceptor>();
            for (Class<? extends RequestInterceptor> itemInterceptorClazz : methodInterceptors) {
                Object itemInterceptorIns = SpringBeanUtils.getBean(StringUtil.lowerFirst(itemInterceptorClazz.getSimpleName()));
                if (itemInterceptorIns == null) continue;
                interceptorInstances.add((RequestInterceptor)itemInterceptorIns);
            }
            routeInfoHolder.setInterceptorStack(interceptorInstances);
            results.put(method, routeInfoHolder);
            this.routeControls.put(PathUtil.getInstance().combine2(classRoute, requestMapping.value()), routeInfoHolder);
        }
    }

    private Set<Class<? extends RequestInterceptor>> loadInterceptor(AnnotatedElement obj) {
        HashSet<Class<? extends RequestInterceptor>> interceptorStack = new HashSet<Class<? extends RequestInterceptor>>();
        Intercept intercept = obj.getAnnotation(Intercept.class);
        this.loadInterceptor0(interceptorStack, intercept);
        return interceptorStack;
    }

    private void loadInterceptor0(Set<Class<? extends RequestInterceptor>> interceptorStack, Intercept classIntercept) {
        Class<? extends RequestInterceptor>[] classIntercrptors;
        if (classIntercept != null && (classIntercrptors = classIntercept.value()) != null) {
            Collections.addAll(interceptorStack, classIntercrptors);
        }
    }

    private void loadClearInterceptor(AnnotatedElement obj, Set<Class<? extends RequestInterceptor>> interceptorStack) {
        Clear classClear = obj.getAnnotation(Clear.class);
        if (classClear != null) {
            Class<? extends RequestInterceptor>[] classClears;
            for (Class<? extends RequestInterceptor> itemClear : classClears = classClear.value()) {
                interceptorStack.remove(itemClear);
            }
        }
    }

    public RouteMatchResult getRoute(HttpServletRequest request) {
        String requestPath = RequestUtil.getRealRequestURIWithoutPrefix(request);
        requestPath = PathUtil.getInstance().removeLastSlash(requestPath);
        HashMap<String, String> routeParams = new HashMap<String, String>();
        if (this.routeMatchCache.containsKey(requestPath)) {
            String route = this.routeMatchCache.get(requestPath);
            if (PathUtil.getInstance().matchPath(route, requestPath, routeParams)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("\u8def\u7531\u5339\u914d\u8d70\u7f13\u5b58\uff0curl:" + requestPath));
                }
                RouteMatchResult routeResult = new RouteMatchResult();
                routeResult.setMappingInfo(this.routeControls.get(route));
                routeResult.setRouteParams(routeParams);
                return routeResult;
            }
        }
        Set<String> routes = this.routeControls.keySet();
        for (String route : routes) {
            if (StringUtils.isEmpty((Object)route)) continue;
            routeParams.clear();
            if (!PathUtil.getInstance().matchPath(route, requestPath, routeParams)) continue;
            this.routeMatchCache.put(requestPath, route);
            RouteMatchResult routeResult = new RouteMatchResult();
            routeResult.setMappingInfo(this.routeControls.get(route));
            routeResult.setRouteParams(routeParams);
            return routeResult;
        }
        return null;
    }
}

