/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework.handler;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.CollectionUtils;
import wang.moshu.smvc.framework.domain.MultipartParseResult;
import wang.moshu.smvc.framework.domain.ParamModel;
import wang.moshu.smvc.framework.domain.RouteInfoHolder;
import wang.moshu.smvc.framework.domain.RouteMatchResult;
import wang.moshu.smvc.framework.enums.RequestDataType;
import wang.moshu.smvc.framework.enums.RequestType;
import wang.moshu.smvc.framework.exception.BeanInstantiationException;
import wang.moshu.smvc.framework.multipart.CommonsMultipartFile;
import wang.moshu.smvc.framework.multipart.MultipartFile;
import wang.moshu.smvc.framework.util.ClassUtil;
import wang.moshu.smvc.framework.util.MethodParamNameVisitor;

public class RequestParamHandler {
    private static final List<String> OTHER_OBJECT_TYPE_LIST = new ArrayList<String>();
    private static final String RESULT_TYPE = "java.util.Map";
    private static final String REQUEST_TYPE = "javax.servlet.http.HttpServletRequest";
    private static final String RESPONSE_TYPE = "javax.servlet.http.HttpServletResponse";
    private static final String MULTIPART_TYPE = "org.smvc.framework.multipart.MultipartFile";
    private static Logger logger = LogManager.getLogger(RequestParamHandler.class);
    private static Map<Class<?>, Object> cachedInstance = new HashMap();

    public static <T> T instantiate(Class<T> clazz) throws BeanInstantiationException {
        if (cachedInstance.containsKey(clazz)) {
            return (T)cachedInstance.get(clazz);
        }
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        try {
            T instance = clazz.newInstance();
            cachedInstance.put(clazz, instance);
            return instance;
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(clazz, "Is it an abstract class?", ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(clazz, "Is the constructor accessible?", ex);
        }
    }

    public static <T> Field[] getClassFieldNames(Class<T> clazz) throws BeanInstantiationException {
        if (clazz.isInterface()) {
            throw new BeanInstantiationException(clazz, "Specified class is an interface");
        }
        return clazz.getDeclaredFields();
    }

    public static ParamModel getMethodParams(RouteMatchResult routeResult, HttpServletRequest request, HttpServletResponse response, RequestType requestType) {
        ParamModel paramModel = new ParamModel();
        RouteInfoHolder mappingInfo = routeResult.getMappingInfo();
        Class<?>[] paramTypes = mappingInfo.getMethod().getParameterTypes();
        Map<String, String> routeParams = routeResult.getRouteParams();
        MultipartParseResult multipartParseResult = null;
        if (RequestParamHandler.isMultipart(request)) {
            multipartParseResult = RequestParamHandler.parseMultipart(request);
        }
        String[] paramNames = MethodParamNameVisitor.getMethodParamNames(mappingInfo.getMethod());
        Object[] objs = new Object[paramTypes.length];
        int resultMapIndex = -1;
        for (int i = 0; i < paramTypes.length; ++i) {
            if (OTHER_OBJECT_TYPE_LIST.contains(paramTypes[i].getName())) {
                objs[i] = RequestParamHandler.getRequestParam(request, paramNames[i], requestType, paramTypes[i].getName(), routeParams);
                continue;
            }
            if (RESULT_TYPE.equals(paramTypes[i].getName())) {
                objs[i] = new HashMap();
                resultMapIndex = i;
                continue;
            }
            if (REQUEST_TYPE.equals(paramTypes[i].getName())) {
                objs[i] = request;
                continue;
            }
            if (RESPONSE_TYPE.equals(paramTypes[i].getName())) {
                objs[i] = response;
                continue;
            }
            if (MULTIPART_TYPE.equals(paramTypes[i].isArray() ? paramTypes[i].getComponentType().getName() : paramTypes[i].getName())) {
                if (CollectionUtils.isEmpty(multipartParseResult.getFiles())) continue;
                objs[i] = paramTypes[i].isArray() ? multipartParseResult.getFiles().get(paramNames[i]).toArray(new MultipartFile[0]) : (Serializable)multipartParseResult.getFiles().get(paramNames[i]).get(0);
                continue;
            }
            objs[i] = RequestParamHandler.setUserModel(mappingInfo, paramTypes[i], request, requestType, multipartParseResult);
        }
        paramModel.setParams(objs);
        paramModel.setResultMapIndex(resultMapIndex);
        return paramModel;
    }

    private static Object getRequestParam(HttpServletRequest request, String paramName, RequestType requestType, String paramTypeName) {
        return RequestParamHandler.getRequestParam(request, paramName, requestType, paramTypeName, null);
    }

    private static Object getRequestParam(HttpServletRequest request, String paramName, RequestType requestType, String paramTypeName, Map<String, String> routeParams) {
        Object value = null;
        try {
            String originalValue = null;
            originalValue = routeParams != null && routeParams.containsKey(paramName) ? routeParams.get(paramName) : request.getParameter(paramName);
            if (StringUtils.isEmpty((String)originalValue)) {
                return null;
            }
            String valueStr = "";
            valueStr = RequestType.GET.equals((Object)requestType) ? new String(originalValue.getBytes("iso8859_1"), "utf-8") : originalValue;
            valueStr = URLDecoder.decode(valueStr, "utf-8");
            if ("java.lang.String".equals(paramTypeName)) {
                value = valueStr;
            } else if ("java.lang.Integer".equals(paramTypeName)) {
                value = Integer.valueOf(valueStr);
            } else if ("java.lang.Float".equals(paramTypeName)) {
                value = Float.valueOf(valueStr);
            } else if ("java.lang.Double".equals(paramTypeName)) {
                value = Double.valueOf(valueStr);
            } else if ("java.lang.Long".equals(paramTypeName)) {
                value = Long.valueOf(valueStr);
            } else if ("java.lang.Boolean".equals(paramTypeName)) {
                value = Boolean.valueOf(valueStr);
            } else if ("java.lang.Byte".equals(paramTypeName)) {
                value = Byte.valueOf(valueStr);
            }
            return value;
        }
        catch (UnsupportedEncodingException e1) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLine(HttpServletRequest request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            ServletInputStream in = request.getInputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                if (len <= 0) continue;
                baos.write(buf, 0, len);
            }
            byte[] bytes = baos.toByteArray();
            String string = new String(bytes, "UTF-8");
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (null != baos) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static Object setUserModel(RouteInfoHolder mappingInfo, Class<?> paramType, HttpServletRequest request, RequestType requestType, MultipartParseResult multipartParseResult) {
        if (mappingInfo.getRequestDataType() == RequestDataType.JSON) {
            return RequestParamHandler.setUserModelJson(paramType, request);
        }
        return RequestParamHandler.setUserModelForm(paramType, request, requestType, multipartParseResult);
    }

    private static Object setUserModelJson(Class<?> paramType, HttpServletRequest request) {
        String line = null;
        try {
            if (StringUtils.isNotEmpty((String)request.getQueryString())) {
                line = URLDecoder.decode(request.getQueryString(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (StringUtils.isEmpty(line)) {
            line = RequestParamHandler.readLine(request);
        }
        if (null == line) {
            logger.info((Object)"\u8bf7\u6c42\u503c\u4e3anull");
            try {
                return RequestParamHandler.instantiate(paramType);
            }
            catch (BeanInstantiationException e) {
                logger.error((Object)("convert json failed! readLine = {" + line + "}"));
                throw new RuntimeException(e);
            }
        }
        try {
            return JSON.parseObject((String)line, paramType);
        }
        catch (Exception e) {
            logger.error((Object)("convert json failed! readLine = {" + line + "}"));
            throw new RuntimeException(e);
        }
    }

    private static Object setUserModelForm(Class<?> paramType, HttpServletRequest request, RequestType requestType, MultipartParseResult multipartParseResult) {
        try {
            Object userModel = RequestParamHandler.instantiate(paramType);
            Field[] fields = ClassUtil.getDeclaredFields(paramType, true);
            BeanWrapperImpl wrapper = new BeanWrapperImpl(userModel);
            for (Field field : fields) {
                String fieldName = field.getName();
                Object fieldValue = null;
                fieldValue = multipartParseResult != null ? (MULTIPART_TYPE.equals(field.getType().isArray() ? field.getType().getComponentType().getName() : field.getType().getName()) ? (CollectionUtils.isEmpty(multipartParseResult.getFiles()) ? null : (field.getType().isArray() ? multipartParseResult.getFiles().get(fieldName).toArray() : (Serializable)multipartParseResult.getFiles().get(fieldName).get(0))) : (CollectionUtils.isEmpty(multipartParseResult.getFields()) ? null : multipartParseResult.getFields().get(fieldName))) : RequestParamHandler.getRequestParam(request, fieldName, requestType, "java.lang.String");
                try {
                    wrapper.setPropertyValue(fieldName, fieldValue);
                }
                catch (Exception ex) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Can't set field [").append(fieldName).append("] of class[").append(paramType.getName()).append("].");
                    logger.warn((Object)sb.toString(), (Throwable)ex);
                }
            }
            return userModel;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error happened when setting fields of class [" + paramType.getName() + "]."), e);
            }
            return null;
        }
    }

    private static boolean isMultipart(HttpServletRequest request) {
        return request != null && ServletFileUpload.isMultipartContent((HttpServletRequest)request);
    }

    private static MultipartParseResult parseMultipart(HttpServletRequest request) {
        MultipartParseResult result = new MultipartParseResult();
        HashMap files = null;
        HashMap<String, String> fields = null;
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            List list = upload.parseRequest(request);
            for (FileItem item : list) {
                if (item.isFormField()) {
                    if (fields == null) {
                        fields = new HashMap<String, String>();
                    }
                    fields.put(item.getFieldName(), item.getString("utf-8"));
                    continue;
                }
                if (files == null) {
                    files = new HashMap();
                }
                if (files.get(item.getFieldName()) == null) {
                    files.put(item.getFieldName(), new ArrayList());
                }
                ((List)files.get(item.getFieldName())).add(new CommonsMultipartFile(item));
            }
            result.setFiles(files);
            result.setFields(fields);
        }
        catch (FileUploadException e) {
            logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u53d1\u751f\u5f02\u5e38FileUploadException", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u53d1\u751f\u5f02\u5e38Exception", (Throwable)e);
        }
        return result;
    }

    static {
        OTHER_OBJECT_TYPE_LIST.add("java.lang.String");
        OTHER_OBJECT_TYPE_LIST.add("java.lang.Boolean");
        OTHER_OBJECT_TYPE_LIST.add("java.lang.Byte");
        OTHER_OBJECT_TYPE_LIST.add("java.lang.Double");
        OTHER_OBJECT_TYPE_LIST.add("java.lang.Integer");
        OTHER_OBJECT_TYPE_LIST.add("java.lang.Float");
        OTHER_OBJECT_TYPE_LIST.add("java.lang.Long");
    }

    static interface BasicType {
        public static final String STRING = "java.lang.String";
        public static final String BOOLEAN = "java.lang.Boolean";
        public static final String BYTE = "java.lang.Byte";
        public static final String DOUBLE = "java.lang.Double";
        public static final String INTEGER = "java.lang.Integer";
        public static final String FLOAT = "java.lang.Float";
        public static final String LONG = "java.lang.Long";
    }
}

