/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.smvc.framework;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import wang.moshu.smvc.framework.context.ApplicationContext;
import wang.moshu.smvc.framework.context.ContextFactory;
import wang.moshu.smvc.framework.domain.JsonResponse;
import wang.moshu.smvc.framework.domain.ParamModel;
import wang.moshu.smvc.framework.domain.RouteInfoHolder;
import wang.moshu.smvc.framework.domain.RouteMatchResult;
import wang.moshu.smvc.framework.enums.RequestType;
import wang.moshu.smvc.framework.enums.ReturnType;
import wang.moshu.smvc.framework.exception.BusinessException;
import wang.moshu.smvc.framework.handler.RequestParamHandler;
import wang.moshu.smvc.framework.handler.RouteHandler;
import wang.moshu.smvc.framework.interceptor.RequestInterceptor;
import wang.moshu.smvc.framework.util.ClassUtil;
import wang.moshu.smvc.framework.util.RequestUtil;
import wang.moshu.smvc.framework.util.ResponseUtil;

public class DispatchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static String preffix;
    private static String suffix;
    private static ApplicationContext context;
    public static final Logger logger;
    private static Map<String, String> header;

    public void init() throws ServletException {
        super.init();
        try {
            ServletConfig sc = this.getServletConfig();
            context = ContextFactory.getApplicationContext(this.getServletContext(), sc, true);
            if (context == null) {
                logger.error((Object)"Failed to load Application context.Failed to startup.");
                return;
            }
            preffix = context.getViewPreffix();
            suffix = context.getViewSuffix();
            Set<Class<?>> controllerClasses = ClassUtil.getClasses(context.getScanPackage());
            if (controllerClasses == null || controllerClasses.isEmpty()) {
                logger.warn((Object)"Got no classes in scan path!");
            }
            for (Class<?> clazz : controllerClasses) {
                RouteHandler.getInstance().registRouteByClass(clazz);
            }
            header.put("Cache-Control", "no-cache");
            header.put("content-type", "application/json;charset=UTF-8");
        }
        catch (Exception ex) {
            logger.error((Object)"SMVC \u521d\u59cb\u5316\u5931\u8d25");
            throw ex;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doService(request, response, RequestType.GET);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doService(request, response, RequestType.POST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doService(HttpServletRequest request, HttpServletResponse response, RequestType requestType) throws IOException, ServletException {
        request.setCharacterEncoding("UTF-8");
        String requestUrl = RequestUtil.getRealRequestURI(request);
        RouteMatchResult routeResult = RouteHandler.getInstance().getRoute(request);
        if (routeResult == null || routeResult.getMappingInfo().getMethod() == null) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("request uri [" + requestUrl + "] did not match any controller."));
            JsonResponse returnObj = new JsonResponse();
            returnObj.setReturnCode("000404");
            returnObj.setData("404");
            this.handleResult(request, response, null, returnObj);
            return;
        }
        Method targetMethod = routeResult.getMappingInfo().getMethod();
        Set<RequestInterceptor> interceptorStack = routeResult.getMappingInfo().getInterceptorStack();
        JsonResponse returnObj = new JsonResponse();
        try {
            for (RequestInterceptor interceptor : interceptorStack) {
                if (interceptor.preHandle(request, response)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u8bf7\u6c42\u88ab\u62e6\u622a\u5668[" + interceptor.description() + "]\u62e6\u622a\u5e76\u76f4\u63a5\u7ed3\u675f"));
                }
                return;
            }
            ParamModel paramModel = RequestParamHandler.getMethodParams(routeResult, request, response, requestType);
            Object[] args = paramModel.getParams();
            Object result = targetMethod.invoke(routeResult.getMappingInfo().getInstance(), args);
            for (RequestInterceptor interceptor : interceptorStack) {
                interceptor.postHandle(request, response, result);
            }
            if (paramModel.getResultMapIndex() != -1) {
                try {
                    Map resultMap = (Map)args[paramModel.getResultMapIndex()];
                    Set resultIterator = resultMap.keySet();
                    for (Object key : resultIterator) {
                        request.setAttribute(key.toString(), resultMap.get(key));
                    }
                }
                catch (ClassCastException ex) {
                    logger.warn((Object)("Can't cast user resultmap to Map<Object, Object>.Please Check method[" + targetMethod.toGenericString() + "]."));
                }
            }
            if (result instanceof JsonResponse) {
                returnObj = (JsonResponse)result;
                returnObj.setCode(0);
                returnObj.setMessage(StringUtils.isEmpty((String)returnObj.getMessage()) ? "" : returnObj.getMessage());
                returnObj.setReturnCode(StringUtils.isEmpty((String)returnObj.getReturnCode()) ? "" : returnObj.getReturnCode());
            } else {
                returnObj.setCode(0);
                returnObj.setData(result);
                returnObj.setMessage("");
                returnObj.setReturnCode("");
            }
        }
        catch (Exception e) {
            String resultCode = "";
            String appendMessage = "";
            if (e instanceof InvocationTargetException) {
                InvocationTargetException exception = (InvocationTargetException)e;
                Throwable t = exception.getCause();
                if (t instanceof BusinessException) {
                    BusinessException exceptionx = (BusinessException)t;
                    resultCode = exceptionx.getErrorCode();
                    appendMessage = exceptionx.getErrorInfo();
                } else {
                    appendMessage = ((InvocationTargetException)e).getTargetException().getMessage();
                }
            } else if (e instanceof BusinessException) {
                BusinessException exceptionx = (BusinessException)e;
                resultCode = exceptionx.getErrorCode();
                appendMessage = exceptionx.getErrorInfo();
            } else {
                logger.error((Object)"", (Throwable)e);
                appendMessage = e.getMessage();
            }
            if (StringUtils.isEmpty((String)resultCode)) {
                resultCode = "000001";
            }
            returnObj.setCode(1);
            returnObj.setData("");
            returnObj.setMessage(appendMessage);
            returnObj.setReturnCode(resultCode);
        }
        finally {
            for (RequestInterceptor interceptor : interceptorStack) {
                interceptor.commitHandle(request, response);
            }
        }
        this.handleResult(request, response, routeResult.getMappingInfo(), returnObj);
    }

    private void handleResult(HttpServletRequest request, HttpServletResponse response, RouteInfoHolder mappingInfo, JsonResponse returnObj) throws ServletException, IOException {
        if (mappingInfo != null && mappingInfo.getReturnType().equals((Object)ReturnType.NOTHING)) {
            return;
        }
        if (returnObj.getReturnCode().equals("000404")) {
            this.return404(request, response);
            return;
        }
        if (returnObj.getCode() == 1 && mappingInfo.getReturnType().equals((Object)ReturnType.PAGE)) {
            this.return500(request, response);
            return;
        }
        if (mappingInfo != null && (mappingInfo.getReturnType().equals((Object)ReturnType.JSON) || mappingInfo.getReturnType().equals((Object)ReturnType.PAGE) && StringUtils.isNotEmpty((String)returnObj.getReturnCode()))) {
            SerializeWriter out = new SerializeWriter();
            JSONSerializer serializer = new JSONSerializer(out);
            serializer.config(SerializerFeature.QuoteFieldNames, true);
            serializer.setDateFormat("yyyy-MM-dd HH:mm:ss");
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            serializer.config(SerializerFeature.PrettyFormat, true);
            serializer.config(SerializerFeature.WriteMapNullValue, true);
            serializer.config(SerializerFeature.WriteNullNumberAsZero, true);
            serializer.config(SerializerFeature.WriteNullStringAsEmpty, true);
            serializer.config(SerializerFeature.WriteNullListAsEmpty, true);
            serializer.write((Object)returnObj);
            String json = out.toString();
            out.close();
            ResponseUtil.write(response, header, "UTF-8", new String[]{json});
            return;
        }
        if (returnObj.getData() instanceof String && !returnObj.getReturnCode().equals("000404")) {
            String resultStr = (String)returnObj.getData();
            String resultPage = preffix + resultStr + suffix;
            request.getRequestDispatcher(resultPage).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.return404(request, response);
    }

    private void return404(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(404);
        response.sendError(404);
    }

    private void return500(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(500);
        response.setStatus(500);
    }

    static {
        logger = Logger.getLogger(DispatchServlet.class);
        header = new HashMap<String, String>();
    }
}

