/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.message;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.InitializingBean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import wang.moshu.message.ConvertUtil;

public class RedisUtil
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(RedisUtil.class);
    private volatile JedisPool pool;
    private Integer maxTotal;
    private Integer maxIdle;
    private Integer minIdle;
    private Integer holed;
    private Integer port;
    private String host;
    private Integer timeout;
    private String password;
    private Integer DB;
    private String keyPrefix;

    public void setHoled(Integer holed) {
        this.holed = holed;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDB(Integer dB) {
        this.DB = dB;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void afterPropertiesSet() throws Exception {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(this.maxTotal.intValue());
        config.setMaxIdle(this.maxIdle.intValue());
        config.setMinIdle(this.minIdle.intValue());
        this.pool = new JedisPool((GenericObjectPoolConfig)config, this.host, this.port.intValue(), this.timeout.intValue(), this.password, this.DB.intValue());
    }

    public Jedis getConnent() {
        Jedis jedis = this.pool.getResource();
        return jedis;
    }

    private void close(Jedis jedis) {
        try {
            if (jedis != null) {
                jedis.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"close jedis failed!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T blpop(String key, int waitSeconds, Class<T> clazz) {
        Jedis jedis = null;
        try {
            jedis = this.getConnent();
            List values = jedis.brpop(waitSeconds, (byte[][])new byte[][]{key.getBytes()});
            if (values != null && values.size() > 0) {
                byte[] value = (byte[])values.get(1);
                T t = ConvertUtil.unserialize(value, clazz);
                return t;
            }
            T t = null;
            return t;
        }
        catch (Exception e) {
            logger.error((Object)"redis get data failed!", (Throwable)e);
            T t = null;
            return t;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Long rpush(String key, T value, int second) {
        Jedis jedis = null;
        Long ret = null;
        try {
            jedis = this.getConnent();
            byte[] bytes = ConvertUtil.serialize(value);
            ret = jedis.rpush(key.getBytes(), (byte[][])new byte[][]{bytes});
            if (second > 0) {
                jedis.expire(key, second);
            }
        }
        catch (Exception e) {
            logger.error((Object)("redis lpush data failed , key = " + key), (Throwable)e);
        }
        finally {
            this.close(jedis);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(String key) {
        Jedis jedis = null;
        Long ret = null;
        try {
            jedis = this.getConnent();
            Long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            logger.error((Object)("redis llen data failed , key = " + key), (Throwable)e);
        }
        finally {
            this.close(jedis);
        }
        return ret;
    }
}

