/*
 * Decompiled with CFR 0.152.
 */
package wang.moshu.message;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskRejectedException;
import wang.moshu.message.Message;
import wang.moshu.message.MessageTrunk;
import wang.moshu.message.RedisUtil;

public abstract class AbstarctMessageHandler<T>
implements Runnable {
    private static Log logger = LogFactory.getLog(AbstarctMessageHandler.class);
    @Autowired
    protected MessageTrunk messageTrunk;
    @Autowired
    private RedisUtil redisUtil;
    private String messageType;
    private Class<T> clazz;
    private boolean monitor;
    private int retryTimes = 3;

    @PostConstruct
    public void startListen() {
        new Thread(this).start();
    }

    public AbstarctMessageHandler(String messageType, Class<T> clazz, int retryTimes) {
        this.messageType = messageType;
        this.clazz = clazz;
        this.retryTimes = 3;
    }

    public AbstarctMessageHandler(String messageType, Class<T> clazz) {
        this.messageType = messageType;
        this.clazz = clazz;
    }

    @Override
    public void run() {
        while (true) {
            this.listen();
        }
    }

    public void listen() {
        final Message obj = this.redisUtil.blpop(this.messageType, Integer.MAX_VALUE, Message.class);
        if (obj == null) {
            this.monitor = false;
            logger.warn((Object)"\u6d88\u606f\u5206\u53d1\u5668\u83b7\u53d6redis\u8fde\u63a5\u5931\u8d25");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"\u6d88\u606f\u5206\u53d1\u5668\u7ebf\u7a0b\u6682\u505c\u5931\u8d25");
            }
            return;
        }
        if (!this.monitor) {
            logger.warn((Object)"\u6d88\u606f\u5206\u53d1\u5f00\u59cb");
            this.monitor = true;
        }
        try {
            this.messageTrunk.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        Message message = (Message)obj;
                        try {
                            AbstarctMessageHandler.this.handle(message.getContent());
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex);
                            if (message.getFailTimes() >= AbstarctMessageHandler.this.retryTimes) {
                                AbstarctMessageHandler.this.handleFailed(message.getContent());
                            }
                            message.setFailTimes(message.getFailTimes() + 1);
                            AbstarctMessageHandler.this.messageTrunk.put(message);
                            if (!logger.isDebugEnabled()) break block3;
                            StringBuilder sb = new StringBuilder();
                            sb.append("msg:[").append(message).append("], \u6267\u884c\u5931\u8d25\uff0c\u51c6\u5907\u91cd\u8bd5\u3002");
                            logger.debug((Object)sb.toString());
                        }
                    }
                }
            });
        }
        catch (TaskRejectedException ex) {
            logger.warn((Object)"\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u51c6\u5907\u56de\u5199\u4efb\u52a1\uff0c\u6682\u505c\u672c\u7ebf\u7a0b");
            this.messageTrunk.put(obj);
            try {
                Thread.sleep(this.messageTrunk.getThreadPoolFullSleepSeconds() * 1000);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"\u751f\u4ea7\u8005\u6682\u505c\u5f02\u5e38", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u6d88\u606f\u603b\u7ebf\u53d1\u751f\u5f02\u5e38", (Throwable)ex);
        }
    }

    public abstract void handle(T var1);

    public abstract void handleFailed(T var1);
}

