/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.helper;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import vip.lematech.hrun4j.common.DefinedException;

public class RegExpHelper {
    public static Boolean isExp(String exp) {
        Boolean flag = false;
        if (StringUtils.isEmpty((String)exp)) {
            return false;
        }
        if (RegExpHelper.match("(.*)\\$\\{(.*?)\\}(.*)", exp)) {
            flag = true;
        }
        return flag;
    }

    public static Boolean isParameterizeExp(String exp) {
        Boolean flag = false;
        if (StringUtils.isEmpty((String)exp)) {
            return false;
        }
        if (RegExpHelper.match("(.*)(?<=\\$\\{)P\\((.*)\\)(?=})(.*)", exp)) {
            flag = true;
        }
        return flag;
    }

    private static boolean match(String reg, String str) {
        return Pattern.matches(reg, str);
    }

    public static List<String> find(String reg, String str) {
        Matcher matcher = Pattern.compile(reg).matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static String findString(String reg, String str) {
        if (StrUtil.isEmpty((CharSequence)reg)) {
            String exceptionMsg = String.format("regex expresssion can not empty or null: %s", reg);
            throw new DefinedException(exceptionMsg);
        }
        if (StrUtil.isEmpty((CharSequence)str)) {
            String exceptionMsg = String.format("search str can not empty or null: %s", str);
            throw new DefinedException(exceptionMsg);
        }
        String returnStr = null;
        List<String> list = RegExpHelper.find(reg, str);
        if (list.size() != 0) {
            returnStr = list.get(0);
        }
        return returnStr;
    }

    public static boolean isUrl(String s) {
        Matcher matcher = Pattern.compile("http(s)?://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]").matcher(s);
        return matcher.matches();
    }
}

