/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.helper;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejlchina.okhttps.HttpResult;
import com.ejlchina.okhttps.OkHttps;
import com.ejlchina.okhttps.internal.SyncHttpTask;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.config.RunnerConfig;
import vip.lematech.hrun4j.config.i18n.I18NFactory;
import vip.lematech.hrun4j.entity.http.RequestEntity;
import vip.lematech.hrun4j.entity.http.ResponseEntity;
import vip.lematech.hrun4j.helper.JsonHelper;
import vip.lematech.hrun4j.helper.LittleHelper;
import vip.lematech.hrun4j.helper.LogHelper;

public class OkHttpsHelper {
    private static String getValueEncoded(String val) {
        if (val == null) {
            return null;
        }
        String newValue = val.replace("\n", "");
        int length = newValue.length();
        for (int i = 0; i < length; ++i) {
            char c = newValue.charAt(i);
            if (c > '\u001f' && c < '\u007f') continue;
            try {
                return URLEncoder.encode(newValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return newValue;
    }

    private static Map<String, String> handleHeadersCookie(RequestEntity requestEntity) {
        ConcurrentMap headers = requestEntity.getHeaders();
        Map<String, Object> cookies = requestEntity.getCookies();
        if (MapUtil.isEmpty(headers)) {
            headers = Maps.newConcurrentMap();
        }
        if (!Objects.isNull(cookies)) {
            headers.put("Cookie", OkHttpsHelper.getCookiesWithParams(cookies));
        }
        return headers;
    }

    private static String getCookiesWithParams(Map<String, String> cookies) {
        StringBuilder sb = new StringBuilder();
        if (MapUtil.isNotEmpty(cookies)) {
            for (String key : cookies.keySet()) {
                String value = cookies.get(key);
                try {
                    String sVal = URLEncoder.encode(value, "UTF-8");
                    sb.append(key).append("=").append(sVal).append(";");
                }
                catch (UnsupportedEncodingException e) {
                    String exceptionMsg = String.format("Parameter %s encoding exception, exception information::%s", value, e.getMessage());
                    throw new DefinedException(exceptionMsg);
                }
            }
        }
        return sb.toString();
    }

    public static ResponseEntity executeReq(RequestEntity requestEntity) {
        String method = requestEntity.getMethod();
        String url = requestEntity.getUrl();
        Map<String, String> headers = OkHttpsHelper.handleHeadersCookie(requestEntity);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("request.url"), url), new Object[0]);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("request.method"), method), new Object[0]);
        SyncHttpTask syncHttpTask = OkHttpsHelper.getSyncHttpTask(requestEntity, url);
        OkHttpsHelper.initRequestParameter(requestEntity, headers, syncHttpTask);
        HttpResult httpResult = null;
        long startTime = System.currentTimeMillis();
        if ("GET".equalsIgnoreCase(method)) {
            httpResult = syncHttpTask.get();
        } else if ("POST".equalsIgnoreCase(method)) {
            httpResult = syncHttpTask.post();
        } else if ("DELETE".equalsIgnoreCase(method)) {
            httpResult = syncHttpTask.delete();
        } else if ("PUT".equalsIgnoreCase(method)) {
            httpResult = syncHttpTask.put();
        } else if ("HEAD".equalsIgnoreCase(method)) {
            httpResult = syncHttpTask.head();
        } else if ("PATCH".equalsIgnoreCase(method)) {
            httpResult = syncHttpTask.patch();
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        if (Objects.isNull(httpResult)) {
            throw new DefinedException("The interface response information cannot be empty!");
        }
        Boolean streamObj = requestEntity.getStream();
        ResponseEntity responseEntity = OkHttpsHelper.wrapperResponseEntity(httpResult, streamObj, elapsedTime);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("response.status.code"), LittleHelper.emptyIfNull(responseEntity.getStatusCode())), new Object[0]);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("response.body"), LittleHelper.emptyIfNull(responseEntity.getBody())), new Object[0]);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("response.content.length"), LittleHelper.emptyIfNull(responseEntity.getContentLength())), new Object[0]);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("response.time"), LittleHelper.emptyIfNull(responseEntity.getTime())), new Object[0]);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("response.header"), LittleHelper.emptyIfNull(JSON.toJSONString(responseEntity.getHeaders()))), new Object[0]);
        LogHelper.info(String.format(I18NFactory.getLocaleMessage("response.cookie"), LittleHelper.emptyIfNull(responseEntity.getCookies())), new Object[0]);
        return responseEntity;
    }

    private static void initRequestParameter(RequestEntity requestEntity, Map<String, String> headers, SyncHttpTask syncHttpTask) {
        Object fileObj;
        Object requestBody;
        Object jsonObj;
        Map<String, Object> urlPara = requestEntity.getParams();
        if (MapUtil.isNotEmpty(urlPara)) {
            LogHelper.info(String.format(I18NFactory.getLocaleMessage("request.parameter"), urlPara), new Object[0]);
            syncHttpTask.addUrlPara(urlPara);
        }
        if (MapUtil.isNotEmpty(headers)) {
            LogHelper.info(String.format(I18NFactory.getLocaleMessage("request.header"), headers), new Object[0]);
            if (headers.containsKey("Cookie")) {
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("request.cookie"), LittleHelper.emptyIfNull(requestEntity.getCookies())), new Object[0]);
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                headers.put(key, OkHttpsHelper.getValueEncoded(value));
            }
            syncHttpTask.addHeader(headers);
        }
        if (!Objects.isNull(jsonObj = requestEntity.getJson())) {
            try {
                JSONObject jsonData = JSONObject.parseObject((String)JSONObject.toJSONString(jsonObj));
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("request.json"), LittleHelper.emptyIfNull(requestEntity.getJson())), new Object[0]);
                syncHttpTask.bodyType("json");
                syncHttpTask.setBodyPara((Object)jsonData);
            }
            catch (Exception e) {
                String exceptionMsg = String.format("JSON formatting exception, cause of exception: %s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
        }
        if (Objects.nonNull(requestBody = requestEntity.getData())) {
            if (requestBody instanceof Map) {
                syncHttpTask.addBodyPara((Map)requestBody);
            } else if (requestBody instanceof String) {
                syncHttpTask.bodyType("json");
                String requestParam = (String)requestBody;
                syncHttpTask.setBodyPara((Object)requestParam);
            }
        }
        if (Objects.nonNull(fileObj = requestEntity.getFiles()) && fileObj instanceof Map && ((Map)fileObj).size() > 0) {
            Map files = (Map)fileObj;
            for (Map.Entry entry : files.entrySet()) {
                File file = (File)entry.getValue();
                String fileName = (String)entry.getKey();
                syncHttpTask.addFilePara(fileName, file);
            }
            ((SyncHttpTask)syncHttpTask.stepRate(0.1)).setOnProcess(process -> {
                LogHelper.info(I18NFactory.getLocaleMessage("file.upload.process"), new Object[0]);
                long totalBytes = process.getTotalBytes();
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.total.bytes"), totalBytes), new Object[0]);
                long doneBytes = process.getDoneBytes();
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.done.bytes"), doneBytes), new Object[0]);
                double rate = process.getRate();
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.done.rate"), rate), new Object[0]);
                boolean isDone = process.isDone();
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.is.done"), isDone), new Object[0]);
            });
        }
    }

    private static SyncHttpTask getSyncHttpTask(RequestEntity requestEntity, String url) {
        return OkHttps.newBuilder().config(builder -> {
            try {
                Integer readTimeout;
                Integer writeTimeout;
                Integer connectTimeout = requestEntity.getConnectTimeout();
                if (!Objects.isNull(connectTimeout)) {
                    builder.connectTimeout((long)connectTimeout.intValue(), TimeUnit.SECONDS);
                }
                if (!Objects.isNull(writeTimeout = requestEntity.getWriteTimeout())) {
                    builder.writeTimeout((long)writeTimeout.intValue(), TimeUnit.SECONDS);
                }
                if (!Objects.isNull(readTimeout = requestEntity.getReadTimeout())) {
                    builder.readTimeout((long)readTimeout.intValue(), TimeUnit.SECONDS);
                }
                builder.followRedirects(requestEntity.getAllowRedirects().booleanValue());
                Map<String, Object> proxy = requestEntity.getProxy();
                if (!Objects.isNull(proxy)) {
                    String hostname = (String)proxy.get("hostname");
                    Object port = proxy.get("port");
                    int portNumber = Integer.parseInt(String.valueOf(port));
                    InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(hostname, portNumber);
                    builder.proxy(new Proxy(Proxy.Type.HTTP, inetSocketAddress));
                }
            }
            catch (Exception e) {
                String exceptionMsg = String.format("An exception occurred during initialization of the OkHttps configuration. Exception message: %s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
        }).build().sync(url);
    }

    private static ResponseEntity wrapperResponseEntity(HttpResult httpResult, boolean stream, long elapsedTime) {
        ResponseEntity responseEntity = new ResponseEntity();
        if (httpResult.isSuccessful()) {
            int statusCode = httpResult.getStatus();
            responseEntity.setStatusCode(statusCode);
            responseEntity.setContentLength(httpResult.getContentLength());
            responseEntity.setTime((double)elapsedTime * 1.0 / 1000.0);
            HashMap<String, Object> headersMap = new HashMap<String, Object>();
            Headers headerArr = httpResult.getHeaders();
            Set names = headerArr.names();
            for (String name : names) {
                headersMap.put(name, headerArr.get(name));
            }
            responseEntity.setHeaders(headersMap);
            HttpResult.Body body = httpResult.getBody();
            if (!stream) {
                String workDir = RunnerConfig.getInstance().getWorkDirectory().getAbsolutePath();
                if (workDir.endsWith(".")) {
                    workDir = LittleHelper.replaceLast(workDir, ".", "");
                }
                CountDownLatch latch = new CountDownLatch(1);
                String finalWorkDir = workDir;
                body.stepRate(0.1).setOnProcess(process -> {
                    LogHelper.info(I18NFactory.getLocaleMessage("file.download.process"), new Object[0]);
                    long totalBytes = process.getTotalBytes();
                    LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.total.bytes"), totalBytes), new Object[0]);
                    long doneBytes = process.getDoneBytes();
                    LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.done.bytes"), doneBytes), new Object[0]);
                    double rate = process.getRate();
                    LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.done.rate"), rate * 100.0), new Object[0]);
                    boolean isDone = process.isDone();
                    LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.is.done"), isDone), new Object[0]);
                }).toFolder(workDir).setOnFailure(failure -> LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.failure"), failure.getException().getMessage()), new Object[0])).setOnSuccess(file -> {
                    LogHelper.info(String.format(I18NFactory.getLocaleMessage("file.success"), FileUtil.normalize((String)finalWorkDir)), new Object[0]);
                    latch.countDown();
                }).start();
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    String exception = "Download interrupt exception";
                    throw new DefinedException(exception);
                }
            } else {
                String responseContent = body.toString();
                if (JsonHelper.isJson(responseContent)) {
                    responseEntity.setBody(JSON.parseObject((String)responseContent));
                } else {
                    responseEntity.setBody(responseContent);
                }
            }
        }
        return responseEntity;
    }
}

