/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import vip.lematech.hrun4j.common.DefinedException;

public class LittleHelper<T> {
    public static String replaceLast(String text, String regex, String replacement) {
        return text.replaceFirst("(?s)" + regex + "(?!.*?" + regex + ")", replacement);
    }

    public static Integer s2ms(Integer s) {
        Integer ms;
        if (Objects.isNull(s)) {
            return null;
        }
        try {
            ms = s * 1000;
        }
        catch (Exception e) {
            String exceptionMsg = String.format("ms to s occur exception\uff1a%s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return ms;
    }

    public static String getSimpleDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    public static Object emptyIfNull(Object obj) {
        if (Objects.isNull(obj)) {
            return "";
        }
        return obj;
    }

    public static String formatJsonOutput(Object output) {
        if (Objects.isNull(output)) {
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(output);
        }
        catch (JsonProcessingException e) {
            return String.valueOf(output);
        }
    }

    public static Object objectDeepCopy(Object obj, Class clz) {
        Object copyObj;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            copyObj = objectMapper.readValue(objectMapper.writeValueAsString(obj), clz);
        }
        catch (JsonProcessingException e) {
            String exceptionMsg = String.format("An exception occurred in the deep copy of the test case ,Exception Informations:  %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("An exception occurred in the deep copy of the test case ,Exception Informations:  %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return copyObj;
    }
}

