/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPath;
import io.burt.jmespath.jackson.JacksonRuntime;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.helper.LogHelper;

public class JsonHelper {
    private static JmesPath<JsonNode> jmespath = new JacksonRuntime();

    public static Object getJmesPathResult(String exp, String responseEntity) {
        Object dataExtractorValue;
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode actualObj = mapper.readTree(responseEntity);
            Expression compileExp = jmespath.compile(exp);
            JsonNode jsonNode = (JsonNode)compileExp.search((Object)actualObj);
            dataExtractorValue = JsonHelper.getJsonNodeValue(jsonNode);
            if (Objects.isNull(dataExtractorValue) || "null".equals(jsonNode.asText())) {
                if (exp.startsWith("body.") || exp.startsWith("headers.")) {
                    return null;
                }
                return exp;
            }
        }
        catch (Exception e) {
            if (exp.startsWith("body.")) {
                return null;
            }
            if (exp.startsWith("headers.")) {
                if (exp.contains("-")) {
                    JSONObject responseJson = JSONObject.parseObject((String)responseEntity);
                    JSONObject headersJson = responseJson.getJSONObject("headers");
                    String[] headerMetas = exp.split("\\.");
                    if (headerMetas.length == 2) {
                        return headersJson.get((Object)headerMetas[1]);
                    }
                    String exceptionMsg = String.format("Jmespath does not support the current expression %s, please use jsonpath", exp);
                    throw new DefinedException(exceptionMsg);
                }
                return null;
            }
            dataExtractorValue = exp;
        }
        return dataExtractorValue;
    }

    private static Object getJsonNodeValue(JsonNode jsonNode) {
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isDouble() || jsonNode.isFloat()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        return jsonNode.asText();
    }

    public static String getJsonPathResult(String exp, String respStr) {
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(respStr);
        String searchResult = (String)JsonPath.read((Object)document, (String)exp, (Predicate[])new Predicate[0]);
        return searchResult;
    }

    public static boolean isJson(String jsonStr) {
        boolean flag = true;
        try {
            JSON.parseObject((String)jsonStr);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public static void jsonWriteToFile(File jsonFilePath, Object json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String value = mapper.writeValueAsString(json);
            FileOutputStream out = new FileOutputStream(jsonFilePath);
            byte[] b = value.getBytes();
            for (int i = 0; i < b.length; ++i) {
                ((OutputStream)out).write(b[i]);
            }
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LogHelper.info("JSON write file exception, exception information: %s", e.getMessage());
        }
    }
}

