/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.helper;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import vip.lematech.hrun4j.common.DefinedException;

public class JavaIdentifierHelper {
    public static boolean isValidJavaIdentifier(String className) {
        if (StrUtil.isEmpty((CharSequence)className) || !Character.isJavaIdentifierStart(className.charAt(0))) {
            return false;
        }
        String name = className.substring(1);
        for (int i = 0; i < name.length(); ++i) {
            char tmpChar = name.charAt(i);
            if (Character.isJavaIdentifierPart(tmpChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaFullClassName(String fullName) {
        if (StrUtil.isEmpty((CharSequence)fullName)) {
            return false;
        }
        boolean flag = true;
        if (!fullName.endsWith(".")) {
            int index = fullName.indexOf(".");
            if (index != -1) {
                String[] str;
                for (String name : str = fullName.split("\\.")) {
                    if (StrUtil.isEmpty((CharSequence)name)) {
                        flag = false;
                    } else {
                        if (JavaIdentifierHelper.isValidJavaIdentifier(name)) continue;
                        flag = false;
                    }
                    break;
                }
            } else if (!JavaIdentifierHelper.isValidJavaIdentifier(fullName)) {
                flag = false;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static String validateIdentifierName(String identifierName) {
        String validateInfo = "";
        if (StrUtil.isEmpty((CharSequence)identifierName)) {
            return " The package  name cannot be empty";
        }
        if (!identifierName.endsWith(".")) {
            int index = identifierName.indexOf(".");
            if (index != -1) {
                String[] str;
                for (String name : str = identifierName.split("\\.")) {
                    if (StrUtil.isEmpty((CharSequence)name)) {
                        return String.format(" The package/directory name [%s] ,sub package name  cannot be empty", identifierName);
                    }
                    if (JavaIdentifierHelper.isValidJavaIdentifier(name)) continue;
                    return String.format(" The package/directory name [%s] ,sub package name [%s] is not valid", identifierName, name);
                }
            } else if (!JavaIdentifierHelper.isValidJavaIdentifier(identifierName)) {
                return String.format(" The package/directory name [%s] is not valid", identifierName);
            }
        } else {
            return String.format(" The package/directory name [%s] can not ends with '.'", identifierName);
        }
        return validateInfo;
    }

    public static String formatFilePath(String filePath) {
        if (StrUtil.isEmpty((CharSequence)filePath)) {
            String exceptionMsg = String.format(" The file path cannot be empty", new Object[0]);
            throw new DefinedException(exceptionMsg);
        }
        filePath = FileUtil.normalize((String)filePath);
        StringBuffer validName = new StringBuffer();
        char[] nameChars = filePath.toCharArray();
        for (int index = 0; index < nameChars.length; ++index) {
            char tmpChar = nameChars[index];
            if (!Character.isJavaIdentifierPart(tmpChar)) {
                validName.append("_");
                continue;
            }
            validName.append(tmpChar);
        }
        return validName.toString();
    }
}

