/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.helper;

import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.regex.Matcher;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.helper.JavaIdentifierHelper;
import vip.lematech.hrun4j.helper.LittleHelper;

public class FilesHelper {
    public static String filePathDecode(String filePath) {
        String decodePath;
        try {
            decodePath = URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            String exceptionMsg = String.format("The file %s encoding is abnormal,Exception information:%s", filePath, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return decodePath;
    }

    public static String dirPath2pkgName(String dirPath) {
        StringBuffer pkgName = new StringBuffer();
        if (StrUtil.isEmpty((CharSequence)dirPath)) {
            return "";
        }
        if (dirPath.startsWith(".")) {
            dirPath = dirPath.replaceFirst("\\.", "");
        }
        if (dirPath.startsWith(File.separator)) {
            dirPath = dirPath.replaceFirst(File.separator, "");
        }
        if (dirPath.endsWith(File.separator)) {
            dirPath = LittleHelper.replaceLast(dirPath, File.separator, "");
        }
        if (dirPath.contains(File.separator)) {
            dirPath = dirPath.replaceAll(File.separator, ".");
        }
        pkgName.append(dirPath);
        String packageName = pkgName.toString();
        if (!JavaIdentifierHelper.isValidJavaFullClassName(packageName)) {
            throw new DefinedException(JavaIdentifierHelper.validateIdentifierName(packageName));
        }
        return packageName;
    }

    public static String pkgPath2DirPath(String pkgPath) {
        if (StrUtil.isEmpty((CharSequence)pkgPath)) {
            String exceptionMsg = "The package name cannot be empty";
            throw new DefinedException(exceptionMsg);
        }
        return pkgPath.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
    }

    public static void checkFileExists(File file) {
        if (Objects.isNull(file)) {
            throw new DefinedException("File instance cannot be null");
        }
        if (!file.exists()) {
            String exceptionMsg = String.format("File %s does not exist on device", file.getAbsolutePath());
            throw new DefinedException(exceptionMsg);
        }
        if (!file.isFile()) {
            String exceptionMsg = String.format("File does not represent a valid file", file.getAbsolutePath());
            throw new DefinedException(exceptionMsg);
        }
    }

    public static void checkDirectoryExists(String absoluteDirPath) {
        if (StrUtil.isEmpty((CharSequence)absoluteDirPath)) {
            throw new DefinedException("Absolute dir path cannot be null/empty");
        }
        File file = new File(absoluteDirPath);
        FilesHelper.checkDirectoryExists(file);
    }

    public static void checkDirectoryExists(File directory) {
        if (directory == null) {
            throw new DefinedException("File instance cannot be null");
        }
        if (!directory.exists()) {
            throw new DefinedException("Directory does not exist on device");
        }
        if (!directory.isFile()) {
            throw new DefinedException("File does not represent a valid directory");
        }
    }
}

