/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.validator;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.entity.testcase.ApiModel;
import vip.lematech.hrun4j.entity.testcase.TestCase;
import vip.lematech.hrun4j.entity.testcase.TestSuite;

public class SchemaValidator {
    private static final JsonSchemaFactory factory = JsonSchemaFactory.byDefault();

    public static String validateJsonObjectFormat(Class clz, Object obj) {
        JsonNode schemaNode;
        String jsonFormatSchema;
        if (clz == TestCase.class) {
            jsonFormatSchema = "/schemas/testcase.json";
        } else if (clz == ApiModel.class) {
            jsonFormatSchema = "/schemas/api.json";
        } else if (clz == TestSuite.class) {
            jsonFormatSchema = "/schemas/testsuite.json";
        } else {
            String exceptionMsg = String.format("Current class %s format validation is not currently supported", clz);
            throw new DefinedException(exceptionMsg);
        }
        try {
            schemaNode = JsonLoader.fromResource((String)jsonFormatSchema);
        }
        catch (IOException ioException) {
            String exceptionMsg = String.format("Error in loading schema file %s. Exception message: %s", jsonFormatSchema, ioException.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        try {
            JsonNode dataNode = JsonLoader.fromString((String)JSON.toJSONString((Object)obj));
            JsonSchema schema = factory.getJsonSchema(schemaNode);
            ProcessingReport processingReport = schema.validate(dataNode);
            if (!processingReport.isSuccess()) {
                StringBuffer errorInfo = new StringBuffer();
                for (ProcessingMessage message : processingReport) {
                    if (!message.getLogLevel().equals((Object)LogLevel.ERROR)) continue;
                    errorInfo.append(message);
                }
                String exceptionMsg = String.format("The format of data %s does not meet the requirements. Reasons: %s,", jsonFormatSchema, errorInfo.toString());
                return exceptionMsg;
            }
        }
        catch (ProcessingException | IOException ioException) {
            String exceptionMsg = String.format("By trying to verify that the JSON exception has occurred, the exception message is:%s", ioException.getMessage());
            return exceptionMsg;
        }
        return null;
    }
}

