/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.validator;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Matcher;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.config.i18n.I18NFactory;
import vip.lematech.hrun4j.core.processor.DataExtractor;
import vip.lematech.hrun4j.core.processor.ExpProcessor;
import vip.lematech.hrun4j.entity.http.ResponseEntity;
import vip.lematech.hrun4j.entity.testcase.Comparator;
import vip.lematech.hrun4j.helper.LogHelper;

public class AssertChecker {
    private DataExtractor dataExtractor;
    private static Map<String, String> alisaMap = new HashMap<String, String>();
    private static Map<String, String> builtInAlisaMap = new HashMap<String, String>();

    public AssertChecker(ExpProcessor expProcessor) {
        this.dataExtractor = new DataExtractor(expProcessor);
    }

    private static Matcher buildMatcherObj(String comparatorName, List<String> params, Object expect) {
        Object obj;
        try {
            Class<?> clzValue = Class.forName("org.hamcrest.Matchers");
            String methodName = alisaMap.containsKey(comparatorName) ? alisaMap.get(comparatorName) : comparatorName;
            Method method = null;
            if (params.size() == 0) {
                method = clzValue.getMethod(methodName, new Class[0]);
            } else if (params.size() == 1) {
                method = clzValue.getMethod(methodName, Class.forName(params.get(0)));
            } else if (params.size() == 2) {
                method = clzValue.getMethod(methodName, Class.forName(params.get(0)), Class.forName(params.get(1)));
            }
            obj = method.invoke(null, expect);
        }
        catch (ClassNotFoundException e) {
            String exceptionMsg = String.format("Class not found exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (NoSuchMethodException e) {
            String exceptionMsg = String.format("No such method exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (IllegalAccessException e) {
            String exceptionMsg = String.format("Illegal access exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (InvocationTargetException e) {
            String exceptionMsg = String.format("Invocation target exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Dynamically build matcher object exceptions, exception information:: %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return (Matcher)obj;
    }

    public void assertObject(Map<String, Object> objectMap, ResponseEntity responseEntity, Map<String, Object> env) {
        Map<String, List> methodAlisaMap = AssertChecker.comparatorAlisaMap();
        Comparator comparator = this.buildComparator(objectMap);
        String comparatorName = comparator.getComparator();
        if (StrUtil.isEmpty((CharSequence)comparatorName)) {
            throw new DefinedException("The validation method name cannot be empty");
        }
        if (!methodAlisaMap.containsKey(comparatorName)) {
            throw new DefinedException(String.format("Validation methods %s are not currently supported. The list of supported method names is:%s", comparatorName, methodAlisaMap));
        }
        Object exp = comparator.getCheck();
        Object actual = this.dataExtractor.handleExpDataExtractor(exp, responseEntity);
        LogHelper.debug("Expression: {}, The extracted value is : {}", exp, actual);
        String assertKeyInfo = String.format("%s%s%s%s%s%s%s", I18NFactory.getLocaleMessage("assert.check.point"), exp, I18NFactory.getLocaleMessage("assert.expect.value"), comparator.getExpect(), I18NFactory.getLocaleMessage("assert.actual.value"), actual, I18NFactory.getLocaleMessage("assert.check.result"));
        try {
            Class<?> clz = Class.forName("org.junit.Assert");
            Method method = clz.getMethod("assertThat", Object.class, Matcher.class);
            method.invoke(null, actual, AssertChecker.buildMatcherObj(comparatorName, methodAlisaMap.get(comparatorName), comparator.getExpect()));
            LogHelper.info(assertKeyInfo + I18NFactory.getLocaleMessage("assert.check.result.pass"), new Object[0]);
        }
        catch (ClassNotFoundException e) {
            String exceptionMsg = String.format("Class not found exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (NoSuchMethodException e) {
            String exceptionMsg = String.format("No such method exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (IllegalAccessException e) {
            String exceptionMsg = String.format("Illegal access exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (InvocationTargetException targetException) {
            LogHelper.error(assertKeyInfo + I18NFactory.getLocaleMessage("assert.check.result.fail"), new Object[0]);
            throw new AssertionError((Object)targetException.getCause());
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Unknown exception occurs in the process of verifying data. Exception information: %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
    }

    private Comparator buildComparator(Map<String, Object> objectMap) {
        Comparator comparator = new Comparator();
        if (objectMap.containsKey("check") && objectMap.containsKey("expect")) {
            comparator = (Comparator)JSON.parseObject((String)JSON.toJSONString(objectMap), Comparator.class);
        } else {
            for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
                comparator.setComparator(entry.getKey());
                Object objValue = entry.getValue();
                if (!(objValue instanceof List)) continue;
                List objValues = (List)objValue;
                if (objValues.size() != 2) {
                    String exceptionMsg = "Verify that the expression is ill-formatted,correct Format eg: '-eq: [statusCode, 200]'";
                    throw new DefinedException(exceptionMsg);
                }
                comparator.setCheck(objValues.get(0));
                comparator.setExpect(objValues.get(1));
            }
        }
        return comparator;
    }

    public void assertList(List<Map<String, Object>> mapList, ResponseEntity responseEntity, Map<String, Object> env) {
        if (Objects.isNull(mapList)) {
            return;
        }
        for (Map<String, Object> objectMap : mapList) {
            this.assertObject(objectMap, responseEntity, env);
        }
    }

    public static Map<String, List> comparatorAlisaMap() {
        HashMap methodMap = Maps.newHashMap();
        try {
            Method[] methods;
            Class<?> matcherClz = Class.forName("org.hamcrest.Matchers");
            for (Method method : methods = matcherClz.getDeclaredMethods()) {
                Class<?>[] types = method.getParameterTypes();
                String methodName = method.getName();
                ArrayList<String> typeList = new ArrayList<String>();
                for (Class<?> type : types) {
                    typeList.add(type.getTypeName());
                }
                methodMap.put(methodName, typeList);
                if (!AssertChecker.isSetAlisa(methodName)) continue;
                String methodAlisa = AssertChecker.transferMethodAlisa(methodName);
                alisaMap.put(methodAlisa, methodName);
                Integer parameterSize = typeList.size();
                if (parameterSize == 1) {
                    methodMap.put(methodAlisa, typeList);
                    continue;
                }
                String overrideMethodName = String.format("%s_%s", methodAlisa, parameterSize);
                methodMap.put(overrideMethodName, typeList);
            }
        }
        catch (ClassNotFoundException e) {
            String exceptionMsg = String.format("Class not found exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return methodMap;
    }

    private static boolean isSetAlisa(String methodName) {
        boolean flag = true;
        if (methodName.length() <= 5) {
            flag = false;
        }
        return flag;
    }

    private static String transferMethodAlisa(String methodName) {
        if (builtInAlisaMap.containsKey(methodName)) {
            return builtInAlisaMap.get(methodName);
        }
        StringBuilder methodAlisa = new StringBuilder();
        char[] chars = methodName.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            char letter = chars[index];
            if (index == 0) {
                methodAlisa.append(letter);
                continue;
            }
            if (!Character.isUpperCase(letter)) continue;
            methodAlisa.append(letter);
        }
        return methodAlisa.toString().toLowerCase();
    }

    static {
        builtInAlisaMap.put("equalTo", "eq");
        builtInAlisaMap.put("lessThan", "lt");
        builtInAlisaMap.put("lessThanOrEqualTo", "le");
        builtInAlisaMap.put("greaterThan", "gt");
        builtInAlisaMap.put("greaterThanOrEqualTo", "ge");
        builtInAlisaMap.put("not", "ne");
    }
}

