/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.runner;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.collections.Maps;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.config.i18n.I18NFactory;
import vip.lematech.hrun4j.core.converter.ObjectConverter;
import vip.lematech.hrun4j.core.loader.Searcher;
import vip.lematech.hrun4j.core.loader.TestDataLoaderFactory;
import vip.lematech.hrun4j.core.processor.DataExtractor;
import vip.lematech.hrun4j.core.processor.ExpProcessor;
import vip.lematech.hrun4j.core.processor.PreAndPostProcessor;
import vip.lematech.hrun4j.core.validator.AssertChecker;
import vip.lematech.hrun4j.entity.http.RequestEntity;
import vip.lematech.hrun4j.entity.http.ResponseEntity;
import vip.lematech.hrun4j.entity.testcase.ApiModel;
import vip.lematech.hrun4j.entity.testcase.Config;
import vip.lematech.hrun4j.entity.testcase.TestCase;
import vip.lematech.hrun4j.entity.testcase.TestStep;
import vip.lematech.hrun4j.helper.LogHelper;
import vip.lematech.hrun4j.helper.OkHttpsHelper;
import vip.lematech.hrun4j.helper.RegExpHelper;

public class TestCaseRunner {
    private ExpProcessor expProcessor = new ExpProcessor();
    private Map<String, Object> testContextVariable = Maps.newHashMap();
    private Searcher searcher = new Searcher();
    private AssertChecker assertChecker = new AssertChecker(this.expProcessor);
    private PreAndPostProcessor preAndPostProcessor = new PreAndPostProcessor(this.expProcessor);
    private ObjectConverter objectConverter = new ObjectConverter();
    private DataExtractor dataExtractor = new DataExtractor(this.expProcessor, this.testContextVariable);

    public void execute(TestCase testCase) {
        try {
            Config config = this.expProcessor.dynHandleContainsExpObject(testCase.getConfig());
            this.preAndPostProcessor.preProcess(config, new RequestEntity());
            List<TestStep> testSteps = testCase.getTestSteps();
            for (int index = 0; index < testSteps.size(); ++index) {
                Map testStepConfigVariable = Maps.newHashMap();
                this.preAndPostProcessor.setTestStepConfigVariable(testStepConfigVariable);
                LogHelper.info(String.format(I18NFactory.getLocaleMessage("runner.current.step"), testSteps.get(index).getName()), new Object[0]);
                Map configVariables = Objects.isNull(config) ? Maps.newHashMap() : (Map)config.getVariables();
                TestStep testStep = this.referenceApiModelOrTestCase(testSteps.get(index), configVariables);
                RequestEntity initializeRequestEntity = testStep.getRequest();
                if (Objects.isNull(initializeRequestEntity)) continue;
                testStepConfigVariable.put("$REQUEST", initializeRequestEntity);
                this.preAndPostProcessor.preProcess(testStep, initializeRequestEntity);
                this.expProcessor.setVariablePriority(testStepConfigVariable, this.testContextVariable, configVariables, (Map)testStep.getVariables());
                RequestEntity requestEntity = this.expProcessor.dynHandleContainsExpObject(initializeRequestEntity);
                requestEntity.setUrl(this.getUrl(config.getBaseUrl(), testStep.getRequest().getUrl()));
                this.formatRequestFiles(requestEntity);
                ResponseEntity responseEntity = OkHttpsHelper.executeReq(requestEntity);
                testStepConfigVariable.put("$RESPONSE", initializeRequestEntity);
                this.preAndPostProcessor.postProcess(testStep, responseEntity);
                List<Map<String, Object>> validateList = testStep.getValidate();
                this.assertChecker.assertList(validateList, responseEntity, testStepConfigVariable);
                this.dataExtractor.extractVariables(testStep.getExtract(), responseEntity, testStepConfigVariable);
            }
            this.preAndPostProcessor.postProcess(config, new ResponseEntity());
        }
        catch (DefinedException definedException) {
            throw definedException;
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Unknown exception occurred in test case  execution. Exception information:%s", e.getMessage());
            LogHelper.debug("Unknown exception occurred in test case  execution. Exception information:{}", e.getStackTrace());
            throw new DefinedException(exceptionMsg);
        }
    }

    private void formatRequestFiles(RequestEntity requestEntity) {
        Object files = requestEntity.getFiles();
        HashMap<String, File> fileList = new HashMap<String, File>();
        if (Objects.nonNull(files) && files instanceof Map) {
            Map fileMaps = (Map)files;
            for (Map.Entry fileMap : fileMaps.entrySet()) {
                String filePath = (String)fileMap.getValue();
                String fileParameterName = (String)fileMap.getKey();
                if (Objects.nonNull(filePath)) {
                    String spliceCaseFilePath = this.searcher.spliceFilePath(filePath, "data");
                    File testCasePath = this.searcher.quicklySearchFile(spliceCaseFilePath);
                    fileList.put(fileParameterName, testCasePath);
                    continue;
                }
                String exceptionMsg = String.format("Data file %s path  cannot be empty", fileMap.getKey());
                throw new DefinedException(exceptionMsg);
            }
        }
        requestEntity.setFiles(fileList);
    }

    private TestStep referenceApiModelOrTestCase(TestStep testStep, Map variables) {
        String api;
        String testcase = testStep.getTestcase();
        if (!StrUtil.isEmpty((CharSequence)testcase)) {
            String spliceCaseFilePath = this.searcher.spliceFilePath(testcase, "testcases");
            File testCasePath = this.searcher.quicklySearchFile(spliceCaseFilePath);
            TestCase testCase = TestDataLoaderFactory.getLoader(FileUtil.extName((String)testcase)).load(testCasePath, TestCase.class);
            Config tcConfig = testCase.getConfig();
            Object referenceCaseVariables = tcConfig.getVariables();
            if (referenceCaseVariables instanceof Map) {
                tcConfig.setVariables(this.objectConverter.mapExtendsKeyValue(variables, (Map)referenceCaseVariables));
            } else {
                LogHelper.warn("Reference test case {}, configuration variable type is not Map type", testcase);
            }
            this.execute(testCase);
        }
        if (!StrUtil.isEmpty((CharSequence)(api = testStep.getApi()))) {
            String spliceApiFilePath = this.searcher.spliceFilePath(api, "apis");
            File apiFilePath = this.searcher.quicklySearchFile(spliceApiFilePath);
            ApiModel apiModel = TestDataLoaderFactory.getLoader(FileUtil.extName((File)apiFilePath)).load(apiFilePath, ApiModel.class);
            TestStep extendTestStep = (TestStep)this.objectConverter.objectsExtendsPropertyValue(this.objectConverter.apiModel2TestStep(apiModel), testStep);
            LogHelper.debug("Interface documentation information:{}, Test steps:{}, After merging:{}", JSON.toJSONString((Object)apiModel), JSON.toJSONString((Object)testStep), JSON.toJSONString((Object)extendTestStep));
            return extendTestStep;
        }
        return testStep;
    }

    private String getUrl(String baseUrl, String requestUrl) {
        if (RegExpHelper.isUrl(requestUrl)) {
            return requestUrl.trim();
        }
        return String.format("%s%s", baseUrl.trim(), StrUtil.isEmpty((CharSequence)requestUrl) ? "" : requestUrl);
    }
}

