/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.provider;

import cn.hutool.core.map.MapUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.collections.Maps;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.config.NamespaceMap;
import vip.lematech.hrun4j.config.RunnerConfig;
import vip.lematech.hrun4j.core.loader.Searcher;
import vip.lematech.hrun4j.core.loader.TestDataLoaderFactory;
import vip.lematech.hrun4j.core.provider.DataConstructor;
import vip.lematech.hrun4j.entity.testcase.Config;
import vip.lematech.hrun4j.entity.testcase.TestCase;
import vip.lematech.hrun4j.helper.FilesHelper;
import vip.lematech.hrun4j.helper.JavaIdentifierHelper;
import vip.lematech.hrun4j.helper.LittleHelper;

public class NGDataProvider {
    private Searcher searcher;
    private DataConstructor dataConstructor;
    String definePackageName = RunnerConfig.getInstance().getPkgName();

    public NGDataProvider() {
        this.searcher = new Searcher();
        this.dataConstructor = new DataConstructor();
    }

    public Object[][] dataProvider(String pkgName, String testCaseName) {
        TestCase testCase = null;
        if (RunnerConfig.getInstance().getRunMode() == RunnerConfig.RunMode.CLI) {
            String namespace = this.getNamespace(pkgName, testCaseName);
            testCase = NamespaceMap.getDataObject(String.format("%s:%s", new Object[]{RunnerConfig.RunMode.CLI, namespace}));
        } else if (RunnerConfig.getInstance().getRunMode() == RunnerConfig.RunMode.POM) {
            File dataFilePath = this.searcher.quicklySearchFile(this.caseFilePath(pkgName, testCaseName));
            String extName = RunnerConfig.getInstance().getTestCaseExtName();
            testCase = TestDataLoaderFactory.getLoader(extName).load(dataFilePath, TestCase.class);
        }
        if (Objects.isNull(testCase)) {
            String exceptionMsg = String.format("According to the current running mode %s and matching rules [pkgName:%s,caseName:%s], find the use case data is empty", new Object[]{RunnerConfig.getInstance().getRunMode(), pkgName, testCaseName});
            throw new DefinedException(exceptionMsg);
        }
        Object[][] testCases = this.getObjects(testCase);
        return testCases;
    }

    private String caseFilePath(String pkgName, String testCaseName) {
        if (pkgName.startsWith(this.definePackageName)) {
            if ((pkgName = FilesHelper.pkgPath2DirPath(pkgName.replaceFirst(this.definePackageName, ""))).startsWith("_")) {
                pkgName = pkgName.replaceFirst("_", ".");
            }
        } else {
            pkgName = FilesHelper.pkgPath2DirPath(pkgName);
        }
        return pkgName + File.separator + testCaseName;
    }

    private String getNamespace(String pkgName, String testCaseName) {
        StringBuffer namespace = new StringBuffer();
        if (pkgName.startsWith(this.definePackageName)) {
            if ((pkgName = pkgName.replaceFirst(this.definePackageName, "")).startsWith("_")) {
                pkgName = pkgName.replaceFirst("_", "");
            }
            if (pkgName.startsWith(".")) {
                pkgName = pkgName.replaceFirst(".", "");
            }
        } else {
            pkgName = FilesHelper.pkgPath2DirPath(pkgName);
        }
        namespace.append(JavaIdentifierHelper.formatFilePath(pkgName));
        namespace.append("_");
        namespace.append(testCaseName);
        return namespace.toString();
    }

    private Object[][] getObjects(TestCase testCase) {
        Object parameterValues = testCase.getConfig().getParameters();
        List<Map<String, Object>> parameters = this.dataConstructor.parameterized(parameterValues);
        if (Objects.isNull(parameters) || parameters.size() == 0) {
            Object[][] testCases = new Object[][]{{testCase}};
            return testCases;
        }
        ArrayList<TestCase> result = new ArrayList<TestCase>();
        Object configVariables = testCase.getConfig().getVariables();
        if (Objects.isNull(configVariables)) {
            configVariables = Maps.newHashMap();
        }
        if (!(configVariables instanceof Map)) {
            String exceptionMsg = String.format("Use case configuration variable types can only be key-value pair types; they cannot be %s", configVariables.getClass());
            throw new DefinedException(exceptionMsg);
        }
        for (Map<String, Object> parameterVariables : parameters) {
            Map resultVariables = Maps.newHashMap();
            resultVariables.putAll((Map)configVariables);
            resultVariables.putAll(MapUtil.isEmpty(parameterVariables) ? Maps.newHashMap() : parameterVariables);
            TestCase copyTestCase = (TestCase)LittleHelper.objectDeepCopy(testCase, TestCase.class);
            Config config = copyTestCase.getConfig();
            config.setVariables(resultVariables);
            config.setParameters(parameterVariables);
            copyTestCase.setConfig(config);
            result.add(copyTestCase);
        }
        Object[][] testCases = new Object[result.size()][];
        for (int i = 0; i < result.size(); ++i) {
            testCases[i] = new Object[]{result.get(i)};
        }
        return testCases;
    }
}

