/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.provider;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.core.processor.ExpProcessor;
import vip.lematech.hrun4j.helper.JsonHelper;
import vip.lematech.hrun4j.helper.RegExpHelper;

public class DataConstructor {
    private ExpProcessor expProcessor = new ExpProcessor();

    public List<Map<String, Object>> parameterized(Object parameterObj) {
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        if (Objects.isNull(parameterObj)) {
            return parameters;
        }
        String paramsStr = JSON.toJSONString((Object)parameterObj);
        if (!JsonHelper.isJson(paramsStr)) {
            String exceptionMsg = String.format("The parameters data %s json format is incorrect", paramsStr);
            throw new DefinedException(exceptionMsg);
        }
        parameterObj = JSONObject.parseObject((String)paramsStr);
        JSONObject jsonObject = (JSONObject)parameterObj;
        boolean isAssociationParameter = false;
        ArrayList<List<Object>> dimValue = new ArrayList<List<Object>>();
        int paramNameIndex = 0;
        HashMap paramNameIndexMap = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = (String)entry.getKey();
            if (StrUtil.isEmpty((CharSequence)string)) {
                String exceptionMsg = String.format("The parameter key name cannot be empty", new Object[0]);
                throw new DefinedException(exceptionMsg);
            }
            String[] paramName = string.split("-");
            Object parameterValue = entry.getValue();
            if (paramName.length > 1) {
                if (jsonObject.size() != 1) {
                    String exceptionMsg = String.format("The correlation parameter needs to specify the parameter name and the corresponding relationship of the parameter value at one time, and the parameter is divided by '-'", new Object[0]);
                    throw new DefinedException(exceptionMsg);
                }
                if (isAssociationParameter) {
                    String exceptionMsg = String.format(" Even if the associated parameter is also a specified parameter is not allowed", new Object[0]);
                    throw new DefinedException(exceptionMsg);
                }
                isAssociationParameter = true;
                return this.associationParameterized(paramName, parameterValue);
            }
            paramNameIndexMap.put(paramNameIndex++, string);
            this.nonAssociationParameterized(dimValue, parameterValue);
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        this.descartes(dimValue, result, 0, new ArrayList<Object>());
        for (List list : result) {
            HashMap parameter = Maps.newHashMap();
            for (int index = 0; index < list.size(); ++index) {
                String paramName = (String)paramNameIndexMap.get(index);
                Object paramValue = list.get(index);
                parameter.put(paramName, paramValue);
            }
            parameters.add(parameter);
        }
        return parameters;
    }

    private void nonAssociationParameterized(List<List<Object>> dimValue, Object parameterValue) {
        if (parameterValue instanceof JSONArray) {
            ArrayList<Object> parameterMutiValues = new ArrayList<Object>();
            JSONArray lineMetaArray = (JSONArray)parameterValue;
            int size = lineMetaArray.size();
            if (size == 1 && lineMetaArray.get(0) instanceof String) {
                String expValue = (String)lineMetaArray.get(0);
                if (RegExpHelper.isExp(expValue).booleanValue()) {
                    Object handleResult = this.handleParameterizeExp(expValue);
                    List csvParameters = (List)handleResult;
                    for (Map objectMap : csvParameters) {
                        for (Map.Entry csvParameter : objectMap.entrySet()) {
                            parameterMutiValues.add(csvParameter);
                        }
                    }
                } else {
                    parameterMutiValues.add(expValue);
                }
            } else {
                for (int index = 0; index < size; ++index) {
                    parameterMutiValues.add(lineMetaArray.get(index));
                }
            }
            dimValue.add(parameterMutiValues);
        } else if (parameterValue instanceof String && RegExpHelper.isExp((String)parameterValue).booleanValue()) {
            Object handleResult = this.handleParameterizeExp((String)parameterValue);
            List csvParameters = (List)handleResult;
            ArrayList parameterMutiValues = new ArrayList();
            for (Map objectMap : csvParameters) {
                for (Map.Entry csvParameter : objectMap.entrySet()) {
                    parameterMutiValues.add(csvParameter);
                }
            }
            dimValue.add(parameterMutiValues);
        } else if (parameterValue instanceof String) {
            ArrayList<Object> onlyOne = new ArrayList<Object>();
            onlyOne.add(parameterValue);
            dimValue.add(onlyOne);
        } else {
            String exceptionMsg = String.format("The parameter value data type is invalid. It can only be String or List", new Object[0]);
            throw new DefinedException(exceptionMsg);
        }
    }

    private Object handleParameterizeExp(String parameterValue) {
        Object handleResult;
        String expValue = parameterValue;
        if (RegExpHelper.isParameterizeExp(expValue).booleanValue()) {
            String filePathValue = RegExpHelper.findString("(?<=\\$\\{P\\()(.*?)(?=\\)})", expValue);
            HashMap environment = Maps.newHashMap();
            environment.put("CVS_FILE_PATH", filePathValue);
            String aliasFileExp = String.format("${P(%s)}", "CVS_FILE_PATH");
            handleResult = this.expProcessor.handleStringExp(aliasFileExp, environment);
        } else {
            handleResult = this.expProcessor.handleStringExp(expValue);
        }
        return handleResult;
    }

    private List<Map<String, Object>> associationParameterized(String[] paramsName, Object paramValues) {
        ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>();
        if (paramValues instanceof JSONArray) {
            JSONArray groupArray = (JSONArray)paramValues;
            for (int i = 0; i < groupArray.size(); ++i) {
                Object lineArray = groupArray.get(i);
                if (!(lineArray instanceof JSONArray)) continue;
                JSONArray lineMetaArray = (JSONArray)lineArray;
                int size = lineMetaArray.size();
                if (paramsName.length < size) {
                    String exceptionMsg = String.format("The number of parameter values should not be greater than the number of parameter lists", new Object[0]);
                    throw new DefinedException(exceptionMsg);
                }
                HashMap oneGroupValue = Maps.newHashMap();
                for (int index = 0; index < size; ++index) {
                    String paramName = paramsName[index];
                    Object paramValue = lineMetaArray.get(index);
                    oneGroupValue.put(paramName, Objects.isNull(paramValue) ? "" : paramValue);
                }
                parameters.add(oneGroupValue);
            }
        } else {
            if (paramValues instanceof String && RegExpHelper.isExp((String)paramValues).booleanValue()) {
                Object handleResult = this.handleParameterizeExp((String)paramValues);
                return (List)handleResult;
            }
            String exceptionMsg = String.format("The parameter value data type is invalid. It can only be String or List", new Object[0]);
            throw new DefinedException(exceptionMsg);
        }
        return parameters;
    }

    private void descartes(List<List<Object>> dimValue, List<List<Object>> result, int layer, List<Object> curList) {
        block7: {
            block6: {
                if (layer >= dimValue.size() - 1) break block6;
                if (dimValue.get(layer).size() == 0) {
                    this.descartes(dimValue, result, layer + 1, curList);
                } else {
                    for (int i = 0; i < dimValue.get(layer).size(); ++i) {
                        ArrayList<Object> list = new ArrayList<Object>(curList);
                        list.add(dimValue.get(layer).get(i));
                        this.descartes(dimValue, result, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimValue.size() - 1) break block7;
            if (dimValue.get(layer).size() == 0) {
                result.add(curList);
            } else {
                for (int i = 0; i < dimValue.get(layer).size(); ++i) {
                    ArrayList<Object> list = new ArrayList<Object>(curList);
                    list.add(dimValue.get(layer).get(i));
                    result.add(list);
                }
            }
        }
    }
}

