/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.processor;

import cn.hutool.core.map.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.collections.Maps;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.core.processor.ExpProcessor;
import vip.lematech.hrun4j.entity.base.BaseModel;
import vip.lematech.hrun4j.entity.http.RequestEntity;
import vip.lematech.hrun4j.entity.http.ResponseEntity;
import vip.lematech.hrun4j.entity.testcase.TestStep;
import vip.lematech.hrun4j.helper.LogHelper;

public class PreAndPostProcessor {
    private Map<String, Object> testStepConfigVariable;
    private ExpProcessor expProcessor;

    public void setTestStepConfigVariable(Map<String, Object> testStepConfigVariable) {
        this.testStepConfigVariable = testStepConfigVariable;
    }

    public PreAndPostProcessor(ExpProcessor expProcessor) {
        this.expProcessor = expProcessor;
    }

    public void preProcess(BaseModel baseModel, RequestEntity requestEntity) {
        if (baseModel instanceof TestStep && !Objects.isNull(requestEntity)) {
            this.testStepConfigVariable.put("$REQUEST", requestEntity);
        }
        if (Objects.isNull(baseModel)) {
            String exceptionMsg = String.format("BaseModel object cannot be null", new Object[0]);
            throw new DefinedException(exceptionMsg);
        }
        this.expProcessor.handleVariables2Map(baseModel);
        Object hookObj = baseModel.getSetupHooks();
        if (Objects.isNull(hookObj)) {
            return;
        }
        this.process(baseModel, hookObj);
    }

    private void outputVariables(TestStep transTestStep) {
        List outputs = transTestStep.getOutput();
        if (!Objects.isNull(outputs)) {
            if (outputs.contains("variables")) {
                LogHelper.info("[variables]\uff1a{}", transTestStep.getVariables());
            }
            if (outputs.contains("extract")) {
                LogHelper.info("[extract]\uff1a{}", this.testStepConfigVariable);
            }
        }
    }

    public void postProcess(BaseModel obj, ResponseEntity responseEntity) {
        Object hookMeta;
        if (obj instanceof TestStep && !Objects.isNull(responseEntity)) {
            this.testStepConfigVariable.put("$RESPONSE", responseEntity);
        }
        if (Objects.isNull(hookMeta = obj.getTeardownHooks())) {
            return;
        }
        this.process(obj, hookMeta);
        if (obj instanceof TestStep) {
            this.outputVariables((TestStep)obj);
        }
    }

    private void process(BaseModel baseModel, Object hookMeta) {
        Map result = this.expProcessor.handleHookExp(hookMeta);
        Map variablesMap = Maps.newHashMap();
        variablesMap.putAll(MapUtil.isEmpty((Map)((Map)baseModel.getVariables())) ? Maps.newHashMap() : (Map)baseModel.getVariables());
        variablesMap.putAll(MapUtil.isEmpty((Map)result) ? Maps.newHashMap() : result);
        baseModel.setVariables(variablesMap);
    }
}

