/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.processor;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.core.converter.ObjectConverter;
import vip.lematech.hrun4j.core.processor.BuiltInAviatorEvaluator;
import vip.lematech.hrun4j.entity.base.BaseModel;
import vip.lematech.hrun4j.entity.http.RequestEntity;
import vip.lematech.hrun4j.entity.testcase.Config;
import vip.lematech.hrun4j.helper.LogHelper;
import vip.lematech.hrun4j.helper.RegExpHelper;

public class ExpProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger(ExpProcessor.class);
    private Map<String, Object> currentVariable = new HashMap<String, Object>();
    private Map<String, Object> configVars = new HashMap<String, Object>();
    private Map<String, Object> testStepVars = new HashMap<String, Object>();
    private ObjectConverter objectConverter = new ObjectConverter();

    public <T> T dynHandleContainsExpObject(T t) {
        if (Objects.isNull(t)) {
            String exceptionMsg = String.format("Expression object cannot be null", new Object[0]);
            throw new DefinedException(exceptionMsg);
        }
        if (t instanceof Map) {
            Map instance = (Map)t;
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry entry : instance.entrySet()) {
                String key = (String)entry.getKey();
                String value = String.valueOf(entry.getValue());
                if (!RegExpHelper.isExp(value).booleanValue()) {
                    result.put(key, value);
                    continue;
                }
                Object handledValue = this.handleStringExp(value);
                result.put(key, handledValue);
                LogHelper.debug("Expression before handle: {}, after handle: {},Current environment variable: {}", value, handledValue, this.currentVariable);
            }
            return (T)result;
        }
        if (t instanceof String) {
            String str = (String)t;
            return (T)this.handleStringExp(str);
        }
        if (t instanceof RequestEntity || t instanceof Config) {
            return (T)this.handleBuiltInObject(t);
        }
        return t;
    }

    public Object handleStringExp(String exp, Map<String, Object> environment) {
        this.currentVariable.putAll(environment);
        return this.handleStringExp(exp);
    }

    public Object handleStringExp(String exp) {
        if (RegExpHelper.isExp(exp).booleanValue()) {
            String handleExp = new String(exp.getBytes());
            try {
                List<String> matchList = RegExpHelper.find("(?<=\\$\\{).*?(?=})", exp);
                String matchExp = matchList.get(0);
                if (matchList.size() == 1) {
                    String onlyExp = String.format("${%s}", matchExp);
                    if (exp.equals(onlyExp)) {
                        return BuiltInAviatorEvaluator.execute(matchExp, this.currentVariable);
                    }
                    exp = this.getExpString(exp, matchList);
                } else {
                    exp = this.getExpString(exp, matchList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String exceptionMsg = String.format("Handle expression %s handles exception, exception information: %s", exp, e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
            LogHelper.debug("Expression before handle: {}, after handle: {},Current environment variable: {}", handleExp, exp, this.currentVariable);
        }
        return exp;
    }

    private String getExpString(String exp, List<String> matchList) {
        ArrayList<String> matchedList = new ArrayList<String>();
        for (String subExp : matchList) {
            Object result = BuiltInAviatorEvaluator.execute(subExp, this.currentVariable);
            String handleResult = String.valueOf(result);
            matchedList.add(handleResult);
        }
        for (String matched : matchedList) {
            exp = exp.replaceFirst("\\$\\{.*?}", matched);
        }
        return exp;
    }

    private void handleVariablesExpression(Map<String, Object> configVars, Map<String, Object> testStepVars) {
        this.configVars = this.dynHandleContainsExpObject(configVars);
        this.testStepVars = this.dynHandleContainsExpObject(testStepVars);
    }

    public Map handleHookExp(Object hookObj) {
        HashMap result = Maps.newHashMap();
        if (hookObj instanceof Map) {
            result.putAll((Map)this.dynHandleContainsExpObject(hookObj));
        } else if (hookObj instanceof List) {
            List tempList = (List)hookObj;
            for (Object obj : tempList) {
                if (obj instanceof String) {
                    this.handleStringExp(String.valueOf(obj));
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                result.putAll((Map)this.dynHandleContainsExpObject(obj));
            }
        } else if (hookObj instanceof String) {
            this.handleStringExp(String.valueOf(hookObj));
        }
        return result;
    }

    public void setVariablePriority(Map<String, Object> currentVariable, Map<String, Object> testContextVariable, Map<String, Object> configVars, Map<String, Object> testStepVars) {
        this.handleVariablesExpression(configVars, testStepVars);
        currentVariable.putAll((Map<String, Object>)(MapUtil.isEmpty(configVars) ? Maps.newHashMap() : this.configVars));
        currentVariable.putAll(testContextVariable);
        currentVariable.putAll((Map<String, Object>)(MapUtil.isEmpty(testStepVars) ? Maps.newHashMap() : this.testStepVars));
        this.currentVariable = currentVariable;
    }

    private Object handleBuiltInObject(Object object) {
        Field[] fields = object.getClass().getDeclaredFields();
        int fieldLength = fields.length;
        for (int index = 0; index < fieldLength; ++index) {
            String exceptionMsg;
            String attributeName = fields[index].getName();
            Class<?> attributeClass = fields[index].getType();
            fields[index].setAccessible(true);
            String methodName = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
            try {
                JSONObject jsonObject;
                Method setMethod;
                Object fieldValue = this.objectConverter.getFieldValueByName(fields[index].getName(), object);
                if (StrUtil.isEmptyIfStr((Object)fieldValue)) continue;
                if (attributeClass == String.class) {
                    setMethod = object.getClass().getMethod("set" + methodName, String.class);
                    setMethod.invoke(object, this.dynHandleContainsExpObject(fieldValue));
                    continue;
                }
                if (attributeClass == Map.class) {
                    setMethod = object.getClass().getMethod("set" + methodName, Map.class);
                    setMethod.invoke(object, this.dynHandleContainsExpObject(fieldValue));
                    continue;
                }
                if (attributeClass == JSONObject.class) {
                    setMethod = object.getClass().getMethod("set" + methodName, JSONObject.class);
                    jsonObject = (JSONObject)JSON.parseObject((String)this.dynHandleContainsExpObject(JSON.toJSONString((Object)fieldValue)), JSONObject.class);
                    setMethod.invoke(object, jsonObject);
                    continue;
                }
                if (object.getClass() == RequestEntity.class && methodName.equals("Json")) {
                    setMethod = object.getClass().getMethod("set" + methodName, Object.class);
                    jsonObject = (JSONObject)JSON.parseObject((String)this.dynHandleContainsExpObject(JSON.toJSONString((Object)fieldValue)), JSONObject.class);
                    setMethod.invoke(object, jsonObject);
                    continue;
                }
                log.debug("Current Type {} Data Not Processed", attributeClass);
                continue;
            }
            catch (NoSuchMethodException e) {
                exceptionMsg = String.format("No such method exception %s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
            catch (IllegalAccessException e) {
                exceptionMsg = String.format("Illegal access exception %s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
            catch (InvocationTargetException e) {
                exceptionMsg = String.format("Invocation target exception %s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
            catch (Exception e) {
                exceptionMsg = String.format("Handle built-in object property expression exceptions, exception information: %s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
        }
        return object;
    }

    public void handleVariables2Map(BaseModel baseModel) {
        Object obj = baseModel.getVariables();
        if (obj instanceof Map) {
            return;
        }
        HashMap result = Maps.newHashMap();
        if (obj instanceof List) {
            List tempList = (List)obj;
            for (Object elementObj : tempList) {
                if (elementObj instanceof String) {
                    Object executeResult = BuiltInAviatorEvaluator.execute(String.valueOf(obj), this.currentVariable);
                    if (!(executeResult instanceof Map)) continue;
                    result.putAll((Map)executeResult);
                    continue;
                }
                if (!(elementObj instanceof Map)) continue;
                result.putAll((Map)elementObj);
            }
        }
        baseModel.setVariables(result);
    }
}

