/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.processor;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.core.processor.ExpProcessor;
import vip.lematech.hrun4j.entity.http.ResponseEntity;
import vip.lematech.hrun4j.helper.JsonHelper;
import vip.lematech.hrun4j.helper.LogHelper;
import vip.lematech.hrun4j.helper.RegExpHelper;

public class DataExtractor {
    private ExpProcessor expProcessor;
    private Map testContextVariable;

    public DataExtractor(ExpProcessor expProcessor) {
        this.expProcessor = expProcessor;
    }

    public DataExtractor(ExpProcessor expProcessor, Map testContextVariable) {
        this.expProcessor = expProcessor;
        this.testContextVariable = testContextVariable;
    }

    public Object handleExpDataExtractor(Object exp, ResponseEntity responseEntity) {
        Object dataExtractorValue;
        if (!(exp instanceof String) || Objects.isNull(exp)) {
            return exp;
        }
        String expStr = String.valueOf(exp);
        if (StrUtil.isEmpty((CharSequence)expStr)) {
            return "";
        }
        String responseStr = JSON.toJSONString((Object)responseEntity);
        if (RegExpHelper.isExp(expStr).booleanValue()) {
            dataExtractorValue = this.expProcessor.handleStringExp(expStr);
        } else if (expStr.startsWith("^") && expStr.endsWith("$")) {
            String expression = expStr.substring(1, expStr.length() - 1);
            dataExtractorValue = RegExpHelper.findString(expression, responseStr);
        } else {
            dataExtractorValue = expStr.startsWith("$.") ? JsonHelper.getJsonPathResult(expStr, responseStr) : JsonHelper.getJmesPathResult(expStr, responseStr);
        }
        if (Objects.isNull(dataExtractorValue)) {
            String exceptionMsg = String.format("No data was found by the given matching pattern: %s", exp);
            throw new DefinedException(exceptionMsg);
        }
        return dataExtractorValue;
    }

    public void extractVariables(Object extracts, ResponseEntity responseEntity, Map<String, Object> variable) {
        if (Objects.isNull(extracts)) {
            return;
        }
        Class<?> clz = extracts.getClass();
        LogHelper.debug("Data extractor type : {}", clz);
        if (clz == ArrayList.class) {
            List extractList = (List)extracts;
            for (Map extractMap : extractList) {
                this.extractMap(responseEntity, extractMap, variable);
            }
        } else if (clz == Map.class || clz == LinkedHashMap.class) {
            Map extractMap = (Map)extracts;
            this.extractMap(responseEntity, extractMap, variable);
        } else {
            String exceptionMsg = String.format("The current extractor of this type %s is not supported", clz);
            throw new DefinedException(exceptionMsg);
        }
    }

    private void extractMap(ResponseEntity responseEntity, Map<String, Object> extractMap, Map<String, Object> testStepConfigVariable) {
        for (Map.Entry<String, Object> entry : extractMap.entrySet()) {
            String key = entry.getKey();
            if (Objects.isNull(entry.getValue())) {
                String exceptionMsg = String.format("The data extraction rule cannot be empty", new Object[0]);
                throw new DefinedException(exceptionMsg);
            }
            Object expValue = entry.getValue();
            Object extractValue = this.handleExpDataExtractor(expValue, responseEntity);
            if (extractValue.equals(expValue)) {
                String exceptionMsg = String.format("By extracting the data that the rule %s does not match to the rule", expValue);
                throw new DefinedException(exceptionMsg);
            }
            LogHelper.debug("Extract rule %s, the extracted data value:%s", expValue, extractValue);
            this.testContextVariable.put(key, extractValue);
        }
    }
}

