/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.processor;

import bsh.EvalError;
import bsh.Interpreter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.util.StrUtil;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorRuntimeJavaType;
import com.googlecode.aviator.runtime.type.AviatorString;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.collections.Maps;
import vip.lematech.hrun4j.base.TestBase;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.config.Env;
import vip.lematech.hrun4j.config.RunnerConfig;
import vip.lematech.hrun4j.entity.http.RequestEntity;
import vip.lematech.hrun4j.entity.http.ResponseEntity;
import vip.lematech.hrun4j.helper.LogHelper;

public class BuiltInAviatorEvaluator {
    private static final Logger log = LoggerFactory.getLogger(BuiltInAviatorEvaluator.class);

    public static Object execute(String expression, Map<String, Object> env) {
        try {
            return AviatorEvaluator.execute((String)expression, env, (boolean)false);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Execute exp %s occur error: %s", expression, e.getLocalizedMessage());
            throw new DefinedException(exceptionMsg);
        }
    }

    static {
        AviatorEvaluator.addFunction((AviatorFunction)new BuiltInFunctionEnv());
        AviatorEvaluator.addFunction((AviatorFunction)new BuiltInFunctionParameterize());
        AviatorEvaluator.addFunction((AviatorFunction)new BuiltInFunctionHelloWorld());
        AviatorEvaluator.addFunction((AviatorFunction)new BuiltInFunctionBeanShell());
    }

    public static class BuiltInFunctionParameterize
    extends AbstractFunction {
        public AviatorObject call(Map<String, Object> env, AviatorObject csvFilePathObj) {
            String workDirPath;
            Object csvFile = csvFilePathObj.getValue(env);
            if (Objects.isNull(csvFile) || StrUtil.isEmpty((CharSequence)csvFile.toString())) {
                String exceptionMsg = String.format("The CVS file path cannot be empty", new Object[0]);
                throw new DefinedException(exceptionMsg);
            }
            String csvFilePathValue = csvFile.toString();
            RunnerConfig.RunMode runMode = RunnerConfig.getInstance().getRunMode();
            File csvFilePath = null;
            if (runMode == RunnerConfig.RunMode.POM) {
                workDirPath = TestBase.class.getClassLoader().getResource("").getPath();
                csvFilePath = new File(workDirPath, csvFilePathValue);
                if (!csvFilePath.exists() || !csvFilePath.isFile()) {
                    String exceptionMsg = String.format("The csv file %s does not exist,Note that in API mode, absolute paths are not allowed, only class paths can be used", FileUtil.getAbsolutePath((File)csvFilePath));
                    throw new DefinedException(exceptionMsg);
                }
            } else if (runMode == RunnerConfig.RunMode.CLI) {
                workDirPath = FileUtil.getAbsolutePath((File)RunnerConfig.getInstance().getWorkDirectory());
                if (!FileUtil.isAbsolutePath((String)csvFilePathValue)) {
                    csvFilePath = new File(workDirPath, csvFilePathValue);
                    if (!csvFilePath.exists() || !csvFilePath.isFile()) {
                        String exceptionMsg = String.format("The csv file %s does not exist", FileUtil.getAbsolutePath((File)csvFilePath));
                        throw new DefinedException(exceptionMsg);
                    }
                } else {
                    csvFilePath = new File(csvFilePathValue);
                    if (!csvFilePath.exists() || !csvFilePath.isFile()) {
                        String exceptionMsg = String.format("The csv file %s does not exist", FileUtil.getAbsolutePath((File)csvFilePath));
                        throw new DefinedException(exceptionMsg);
                    }
                }
            }
            CsvReader reader = CsvUtil.getReader();
            CsvData data = reader.read(csvFilePath, Charset.defaultCharset());
            List rows = data.getRows();
            ArrayList<Map> csvParameters = new ArrayList<Map>();
            Map parameterNameIndexMap = Maps.newHashMap();
            for (int index = 0; index < rows.size(); ++index) {
                CsvRow csvRow = (CsvRow)rows.get(index);
                if (index == 0) {
                    for (int columnIndex = 0; columnIndex < csvRow.size(); ++columnIndex) {
                        parameterNameIndexMap.put(columnIndex, csvRow.get(columnIndex));
                    }
                    continue;
                }
                Map parameter = Maps.newHashMap();
                for (int columnIndex = 0; columnIndex < csvRow.size(); ++columnIndex) {
                    String paramName = (String)parameterNameIndexMap.get(columnIndex);
                    String paramValue = csvRow.get(columnIndex);
                    parameter.put(paramName, paramValue);
                }
                csvParameters.add(parameter);
            }
            return AviatorRuntimeJavaType.valueOf(csvParameters);
        }

        public String getName() {
            return "P";
        }
    }

    public static class BuiltInFunctionBeanShell
    extends AbstractFunction {
        public AviatorObject call(Map<String, Object> env, AviatorObject bshFilePathObj) {
            Object result;
            Object bshFile = bshFilePathObj.getValue(env);
            if (Objects.isNull(bshFile) || StrUtil.isEmpty((CharSequence)bshFile.toString())) {
                String exceptionMsg = String.format("The bsh file path cannot be empty", new Object[0]);
                throw new DefinedException(exceptionMsg);
            }
            String bshFilePathValue = bshFile.toString();
            if (!"bsh".equalsIgnoreCase(FileUtil.extName((String)bshFilePathValue))) {
                String exceptionMsg = String.format("BeanShell scripts must have a.bsh suffix", new Object[0]);
                throw new DefinedException(exceptionMsg);
            }
            RunnerConfig.RunMode runMode = RunnerConfig.getInstance().getRunMode();
            File bshFilePath = null;
            if (runMode == RunnerConfig.RunMode.POM) {
                String workDirPath = TestBase.class.getClassLoader().getResource("").getPath();
                bshFilePath = new File(workDirPath, bshFilePathValue);
                if (!bshFilePath.exists() || !bshFilePath.isFile()) {
                    String exceptionMsg = String.format("The bsh file %s does not exist,Note that in API mode, absolute paths are not allowed, only class paths can be used", FileUtil.getAbsolutePath((File)bshFilePath));
                    throw new DefinedException(exceptionMsg);
                }
            } else if (runMode == RunnerConfig.RunMode.CLI) {
                String workDirPath = FileUtil.getAbsolutePath((File)RunnerConfig.getInstance().getWorkDirectory());
                if (!FileUtil.isAbsolutePath((String)bshFilePathValue)) {
                    bshFilePath = new File(workDirPath, bshFilePathValue);
                    if (!bshFilePath.exists() || !bshFilePath.isFile()) {
                        String exceptionMsg = String.format("The bsh file %s does not exist", FileUtil.getAbsolutePath((File)bshFilePath));
                        throw new DefinedException(exceptionMsg);
                    }
                } else {
                    bshFilePath = new File(bshFilePathValue);
                    if (!bshFilePath.exists() || !bshFilePath.isFile()) {
                        String exceptionMsg = String.format("The bsh file %s does not exist", FileUtil.getAbsolutePath((File)bshFilePath));
                        throw new DefinedException(exceptionMsg);
                    }
                }
            }
            Interpreter interpreter = new Interpreter();
            try {
                RequestEntity requestEntity = (RequestEntity)env.get("$REQUEST");
                interpreter.set("$REQUEST", (Object)requestEntity);
                ResponseEntity responseEntity = (ResponseEntity)env.get("$RESPONSE");
                interpreter.set("$RESPONSE", (Object)responseEntity);
                interpreter.set("$ENV", env);
                env.remove("$RESPONSE");
                env.remove("$REQUEST");
                result = interpreter.source(FileUtil.getAbsolutePath((File)bshFilePath));
            }
            catch (IOException e) {
                String exceptionMsg = String.format("The bsh file %s does not exist", FileUtil.getAbsolutePath((File)bshFilePath));
                throw new DefinedException(exceptionMsg);
            }
            catch (EvalError evalError) {
                evalError.printStackTrace();
                String exceptionMsg = String.format("The BeanShell script executes an exception. Exception information: %s", evalError.getMessage());
                throw new DefinedException(exceptionMsg);
            }
            return AviatorRuntimeJavaType.valueOf((Object)result);
        }

        public String getName() {
            return "BSH";
        }
    }

    public static class BuiltInFunctionEnv
    extends AbstractFunction {
        public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
            Object envValue = arg1.getValue(Env.getEnvMap());
            if (Objects.isNull(envValue)) {
                String exceptionMsg = String.format("env not found key : %s", arg1);
                throw new DefinedException(exceptionMsg);
            }
            return new AviatorString(String.valueOf(envValue));
        }

        public String getName() {
            return "ENV";
        }
    }

    public static class BuiltInFunctionHelloWorld
    extends AbstractFunction {
        public AviatorObject call(Map<String, Object> env) {
            String output = "Hello,hrun4j";
            LogHelper.info(output, new Object[0]);
            return new AviatorString(output);
        }

        public String getName() {
            return "helloWorld";
        }
    }
}

