/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.loader.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.core.converter.ObjectConverter;
import vip.lematech.hrun4j.core.loader.service.ITestDataLoader;
import vip.lematech.hrun4j.core.validator.SchemaValidator;
import vip.lematech.hrun4j.entity.testcase.ApiModel;
import vip.lematech.hrun4j.entity.testcase.TestCase;
import vip.lematech.hrun4j.helper.FilesHelper;

public class TestDataLoaderImpl<T>
implements ITestDataLoader {
    private Yaml yaml;
    private String extName;
    private ObjectMapper mapper;
    private ObjectConverter objectConverter;

    public TestDataLoaderImpl(String extName) {
        this.extName = extName;
        this.yaml = new Yaml((BaseConstructor)new Constructor(JSONObject.class));
        this.mapper = new ObjectMapper();
        this.objectConverter = new ObjectConverter();
    }

    private T fileSerialization2Object(File file, Class clazz) {
        Object result;
        String testDataName = file.getName();
        try {
            String extName = FileUtil.extName((String)testDataName);
            if (!StrUtil.isEmpty((CharSequence)extName)) {
                this.extName = extName;
            }
            if ("json".equalsIgnoreCase(this.extName)) {
                result = this.mapper.readValue((InputStream)new FileInputStream(file), clazz);
            } else if ("yml".equalsIgnoreCase(this.extName)) {
                JSONObject jsonObject = (JSONObject)this.yaml.load((InputStream)new FileInputStream(file));
                result = jsonObject.toJavaObject(clazz);
            } else {
                String exceptionMsg = String.format("The current format %s is not currently supported,you can implement ITestDataLoader interface and try to override load() method", extName);
                throw new DefinedException(exceptionMsg);
            }
            if (Objects.isNull(result)) {
                String exceptionMsg = String.format("The serialized file %s cannot be empty", testDataName);
                throw new DefinedException(exceptionMsg);
            }
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Error in file %s.%s serialization,Exception Information: %s", testDataName, this.extName, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return (T)result;
    }

    public T load(File fileName, Class clazz) {
        FilesHelper.checkFileExists(fileName);
        String testDataName = fileName.getName();
        try {
            T testData = this.fileSerialization2Object(fileName, clazz);
            String validateResult = SchemaValidator.validateJsonObjectFormat(clazz, testData);
            if (StrUtil.isEmpty((CharSequence)validateResult)) {
                return testData;
            }
            if (clazz == TestCase.class) {
                ApiModel apiModel = (ApiModel)this.fileSerialization2Object(fileName, ApiModel.class);
                validateResult = SchemaValidator.validateJsonObjectFormat(ApiModel.class, apiModel);
                if (StrUtil.isEmpty((CharSequence)validateResult)) {
                    return (T)this.objectConverter.apiModel2TestCase(apiModel);
                }
                throw new DefinedException(validateResult);
            }
            throw new DefinedException(validateResult);
        }
        catch (DefinedException definedException) {
            throw definedException;
        }
        catch (Exception e) {
            String exceptionMsg = String.format("An exception occurred in the loading %s file. Exception information:%s", testDataName, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
    }
}

