/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.loader;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import vip.lematech.hrun4j.base.TestBase;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.config.RunnerConfig;
import vip.lematech.hrun4j.helper.FilesHelper;
import vip.lematech.hrun4j.helper.LogHelper;

public class Searcher {
    private RunnerConfig.RunMode runMode = RunnerConfig.getInstance().getRunMode();
    private String workDirectory = RunnerConfig.getInstance().getWorkDirectory().getAbsolutePath();

    public File quicklySearchFile(String filePath) {
        String exceptionMsg;
        if (StrUtil.isEmpty((CharSequence)filePath)) {
            String exceptionMsg2 = String.format("FilePath can not null or empty", new Object[0]);
            throw new DefinedException(exceptionMsg2);
        }
        if (StrUtil.isEmpty((CharSequence)FileUtil.extName((String)filePath))) {
            filePath = filePath + "." + RunnerConfig.getInstance().getTestCaseExtName();
        }
        File searchFile = null;
        if (this.runMode == RunnerConfig.RunMode.CLI) {
            searchFile = FileUtil.isAbsolutePath((String)filePath) ? new File(filePath) : new File(this.workDirectory, FilesHelper.filePathDecode(filePath));
        } else if (this.runMode == RunnerConfig.RunMode.POM) {
            URL url;
            if (!filePath.startsWith(File.separator)) {
                filePath = File.separator + filePath;
            }
            if (Objects.isNull(url = TestBase.class.getResource(filePath))) {
                String exceptionMsg3 = String.format("The file %s was not found under the resources", filePath);
                throw new DefinedException(exceptionMsg3);
            }
            searchFile = new File(FilesHelper.filePathDecode(url.getPath()));
        }
        if (Objects.isNull(searchFile)) {
            exceptionMsg = String.format("File %s is not exist", filePath);
            throw new DefinedException(exceptionMsg);
        }
        if (!searchFile.exists() || !searchFile.isFile()) {
            exceptionMsg = String.format("The file %s was not found in the current path %s", searchFile.getName(), FileUtil.getAbsolutePath((File)searchFile.getParentFile()));
            throw new DefinedException(exceptionMsg);
        }
        LogHelper.debug("Run mode: {}, Test case path {}", new Object[]{this.runMode, FileUtil.getAbsolutePath((File)searchFile)});
        return searchFile;
    }

    public String spliceFilePath(String dataFileType, String directoryName) {
        if (!dataFileType.startsWith(directoryName + File.separator) && !dataFileType.startsWith(File.separator + directoryName + File.separator)) {
            dataFileType = directoryName + File.separator + dataFileType;
        }
        if (FileUtil.isAbsolutePath((String)dataFileType)) {
            dataFileType = "." + dataFileType;
        }
        if (StrUtil.isEmpty((CharSequence)FileUtil.extName((String)dataFileType))) {
            dataFileType = dataFileType + "." + RunnerConfig.getInstance().getTestCaseExtName();
        }
        return dataFileType;
    }

    public RunnerConfig.RunMode getRunMode() {
        return this.runMode;
    }

    public String getWorkDirectory() {
        return this.workDirectory;
    }

    public void setRunMode(RunnerConfig.RunMode runMode) {
        this.runMode = runMode;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Searcher)) {
            return false;
        }
        Searcher other = (Searcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RunnerConfig.RunMode this$runMode = this.getRunMode();
        RunnerConfig.RunMode other$runMode = other.getRunMode();
        if (this$runMode == null ? other$runMode != null : !((Object)((Object)this$runMode)).equals((Object)other$runMode)) {
            return false;
        }
        String this$workDirectory = this.getWorkDirectory();
        String other$workDirectory = other.getWorkDirectory();
        return !(this$workDirectory == null ? other$workDirectory != null : !this$workDirectory.equals(other$workDirectory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Searcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RunnerConfig.RunMode $runMode = this.getRunMode();
        result = result * 59 + ($runMode == null ? 43 : ((Object)((Object)$runMode)).hashCode());
        String $workDirectory = this.getWorkDirectory();
        result = result * 59 + ($workDirectory == null ? 43 : $workDirectory.hashCode());
        return result;
    }

    public String toString() {
        return "Searcher(runMode=" + (Object)((Object)this.getRunMode()) + ", workDirectory=" + this.getWorkDirectory() + ")";
    }
}

