/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.loader;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.StrUtil;
import com.itranswarp.compiler.JavaStringCompiler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Maps;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.helper.LogHelper;

public class HotLoader {
    public static Set<Class> hotLoaderClasses = new HashSet<Class>();
    private static JavaStringCompiler compiler;

    public static synchronized JavaStringCompiler getInstance() {
        if (compiler == null) {
            compiler = new JavaStringCompiler();
        }
        return compiler;
    }

    public static synchronized Class<?> hotLoadClass(String pkgName, String className, String source) {
        Class clazz;
        if (StrUtil.isEmpty((CharSequence)className) || StrUtil.isEmpty((CharSequence)source)) {
            throw new DefinedException("hot load class occur exception: className or source is empty");
        }
        String replaceSource = HotLoader.replaceSourceParameters(pkgName, className, source);
        String javaFileName = String.format("%s.java", className);
        String pkgClassName = String.format("%s.%s", pkgName, className);
        try {
            LogHelper.debug("initializing class[{}] ", pkgClassName);
            Map results = HotLoader.getInstance().compile(javaFileName, replaceSource);
            clazz = compiler.loadClass(pkgClassName, results);
            LogHelper.debug("hot load class[{}] finished", pkgClassName);
            hotLoaderClasses.add(clazz);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("compile %s occur exception: ", javaFileName, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (ClassNotFoundException e) {
            String exceptionMsg = String.format("class %s not found exception: ", pkgClassName, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return clazz;
    }

    private static void traverseSrcJava(String rootPath, File file, List<Map<String, String>> javaMetaInfos) {
        File[] files;
        if (!file.exists()) {
            String msg = String.format("file %s is not exist", file.getName());
            throw new DefinedException(msg);
        }
        for (File javaFile : files = file.listFiles()) {
            if (javaFile.isFile() && javaFile.getName().endsWith(".java")) {
                Map javaMetaInfo = Maps.newHashMap();
                String pkgPath = file.getParent().replace(rootPath, "");
                String[] pkgNames = HotLoader.dirPath2pkgName(pkgPath);
                StringBuffer pkgNameStr = new StringBuffer();
                for (String pkgPortionName : pkgNames) {
                    if (StrUtil.isEmpty((CharSequence)pkgPortionName)) continue;
                    pkgNameStr.append(".").append(pkgPortionName);
                }
                String className = FileNameUtil.mainName((String)file.getName());
                String pkgName = pkgNameStr.toString();
                javaMetaInfo.put("pkgName", pkgName);
                javaMetaInfo.put("className", className);
                javaMetaInfo.put("source", HotLoader.getJavaFileContent(javaFile));
                javaMetaInfos.add(javaMetaInfo);
                LogHelper.debug("package name is {}, class name is {}", pkgName, className);
                continue;
            }
            HotLoader.traverseSrcJava(rootPath, javaFile, javaMetaInfos);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getJavaFileContent(File file) {
        BufferedReader javaFileReader = FileUtil.getReader((File)file, (String)"UTF-8");
        StringBuffer javaFileContent = new StringBuffer();
        try {
            String lineInfo;
            while ((lineInfo = javaFileReader.readLine()) != null) {
                javaFileContent.append(lineInfo);
            }
        }
        catch (IOException ioException) {
            try {
                String exceptionMsg = String.format("file {} occur io exception", file.getName());
                throw new DefinedException(exceptionMsg);
            }
            catch (Throwable throwable) {
                try {
                    javaFileReader.close();
                    throw throwable;
                }
                catch (IOException ioException2) {
                    String exceptionMsg = String.format("close file {} occur exception", file.getName());
                    throw new DefinedException(exceptionMsg);
                }
            }
        }
        try {
            javaFileReader.close();
            return javaFileContent.toString();
        }
        catch (IOException ioException) {
            String exceptionMsg = String.format("close file {} occur exception", file.getName());
            throw new DefinedException(exceptionMsg);
        }
    }

    private static String[] dirPath2pkgName(String pkgPath) {
        if (StrUtil.isEmpty((CharSequence)pkgPath)) {
            return new String[0];
        }
        String[] pkgName = pkgPath.split("/");
        return pkgName;
    }

    private static String replaceSourceParameters(String pkgName, String className, String source) {
        String replaceSource = source;
        LogHelper.debug("init source info : {}", source);
        if (source.contains("$pkgName")) {
            replaceSource = source.replace("$pkgName", pkgName);
        }
        if (source.contains("$className")) {
            replaceSource = replaceSource.replace("className", className);
        }
        LogHelper.debug("replace source parameters info : {}", replaceSource);
        return replaceSource;
    }
}

