/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.engine;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import vip.lematech.hrun4j.common.DefinedException;

public class TemplateEngine {
    private static VelocityEngine velocityEngine;

    private static synchronized VelocityEngine getInstance() {
        if (velocityEngine == null) {
            velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("resource.loader", (Object)"classpath");
            velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            try {
                velocityEngine.init();
            }
            catch (Exception e) {
                String exceptionMsg = String.format("Velocity engine init exception :%s", e.getMessage());
                throw new DefinedException(exceptionMsg);
            }
        }
        return velocityEngine;
    }

    public static String getTemplateRenderContent(String templateName, VelocityContext context) {
        Template template;
        try {
            template = TemplateEngine.getInstance().getTemplate(templateName);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("There was an exception getting the template %s,Exception Informations: ", templateName, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        StringWriter sw = new StringWriter();
        try {
            template.merge((Context)context, (Writer)sw);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("An exception occurred in the rendering engine template %s based on the constructed data,,Exception Informations: %s", templateName, e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        return sw.toString();
    }
}

