/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.core.converter;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.collections.Maps;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.entity.http.RequestEntity;
import vip.lematech.hrun4j.entity.testcase.ApiModel;
import vip.lematech.hrun4j.entity.testcase.Config;
import vip.lematech.hrun4j.entity.testcase.TestCase;
import vip.lematech.hrun4j.entity.testcase.TestStep;
import vip.lematech.hrun4j.helper.LogHelper;

public class ObjectConverter {
    public TestCase apiModel2TestCase(ApiModel apiModel) {
        TestCase testCase = new TestCase();
        TestStep testStep = new TestStep();
        Config config = new Config();
        config.setBaseUrl(apiModel.getBaseUrl());
        BeanUtil.copyProperties((Object)apiModel, testStep, (String[])new String[0]);
        ArrayList<TestStep> testSteps = new ArrayList<TestStep>();
        testSteps.add(testStep);
        testCase.setConfig(config);
        testCase.setTestSteps(testSteps);
        return testCase;
    }

    public TestStep apiModel2TestStep(ApiModel apiModel) {
        TestStep sourceTestStep = new TestStep();
        BeanUtil.copyProperties((Object)apiModel, sourceTestStep, (String[])new String[0]);
        RequestEntity requestEntity = sourceTestStep.getRequest();
        requestEntity.setUrl(apiModel.getRequest().getUrl());
        sourceTestStep.setRequest(requestEntity);
        return sourceTestStep;
    }

    public Object objectsExtendsPropertyValue(Object baseObj, Object extendedObj) {
        if (Objects.isNull(baseObj) || Objects.isNull(extendedObj)) {
            throw new DefinedException("The source and target objects cannot be null");
        }
        if (baseObj.getClass() != extendedObj.getClass()) {
            throw new DefinedException("The source object and the target object must belong to the same class");
        }
        Field[] fields = this.getObjectAllFields(extendedObj);
        int fieldLength = fields.length;
        block0: for (int index = 0; index < fieldLength; ++index) {
            String attributeName = fields[index].getName();
            Class<?> attributeClass = fields[index].getType();
            String methodName = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
            Object fieldValue = this.getFieldValueByName(fields[index].getName(), extendedObj);
            if (Objects.isNull(fieldValue)) continue;
            Field[] subFields = this.getObjectAllFields(baseObj);
            int subFieldLength = subFields.length;
            for (int subIndex = 0; subIndex < subFieldLength; ++subIndex) {
                String subAttributeName = subFields[subIndex].getName();
                Class<?> subAttributeClass = subFields[subIndex].getType();
                String subMethodName = subAttributeName.substring(0, 1).toUpperCase() + subAttributeName.substring(1);
                if (!methodName.equals(subMethodName) || subAttributeClass != attributeClass) continue;
                Object subFieldValue = this.getFieldValueByName(subFields[subIndex].getName(), baseObj);
                LogHelper.debug("Parent Type\uff1a{},Parent Value\uff1a{},Parent Method Name\uff1a{},Child Type\uff1a{},Child Value\uff1a{},Child Method Name\uff1a{}", attributeClass, fieldValue, methodName, subAttributeClass, subFieldValue, subMethodName);
                if (Objects.isNull(subFieldValue)) {
                    this.subFieldValueIsNullAssignment(baseObj, subAttributeClass, methodName, fieldValue);
                    continue block0;
                }
                this.subFieldValueIsNotNullAssignment(baseObj, subAttributeClass, methodName, fieldValue, subFieldValue);
                continue block0;
            }
        }
        return baseObj;
    }

    private void subFieldValueIsNotNullAssignment(Object baseObj, Class subAttributeClass, String methodName, Object fieldValue, Object subFieldValue) {
        try {
            if (subAttributeClass == Map.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Map.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == String.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, String.class);
                setMethod.invoke(baseObj, String.valueOf(fieldValue));
            } else if (subAttributeClass == List.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, List.class);
                setMethod.invoke(baseObj, subFieldValue);
            } else if (subAttributeClass == Integer.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Integer.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == Double.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Double.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == JSONObject.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, JSONObject.class);
                setMethod.invoke(baseObj, subFieldValue);
            } else if (subAttributeClass == Boolean.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Boolean.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == RequestEntity.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, RequestEntity.class);
                RequestEntity targetRequestEntity = (RequestEntity)this.objectsExtendsPropertyValue(subFieldValue, fieldValue);
                setMethod.invoke(baseObj, targetRequestEntity);
            } else if (subAttributeClass == Object.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Object.class);
                setMethod.invoke(baseObj, fieldValue);
            }
        }
        catch (NoSuchMethodException e) {
            String exceptionMsg = String.format("No such method exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (IllegalAccessException e) {
            String exceptionMsg = String.format("Illegal access exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (InvocationTargetException e) {
            String exceptionMsg = String.format("Invocation target exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Object property value inheritance exception, exception information:: %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
    }

    private void subFieldValueIsNullAssignment(Object baseObj, Class subAttributeClass, String methodName, Object fieldValue) {
        try {
            if (subAttributeClass == String.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, String.class);
                setMethod.invoke(baseObj, String.valueOf(fieldValue));
            } else if (subAttributeClass == JSONObject.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, JSONObject.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == List.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, List.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == Map.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Map.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == Integer.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Integer.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == Double.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Double.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == Boolean.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Boolean.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == RequestEntity.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, RequestEntity.class);
                setMethod.invoke(baseObj, fieldValue);
            } else if (subAttributeClass == Object.class) {
                Method setMethod = baseObj.getClass().getMethod("set" + methodName, Object.class);
                setMethod.invoke(baseObj, fieldValue);
            }
        }
        catch (NoSuchMethodException e) {
            String exceptionMsg = String.format("No such method exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (IllegalAccessException e) {
            String exceptionMsg = String.format("Illegal access exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (InvocationTargetException e) {
            String exceptionMsg = String.format("Invocation target exception %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Object property value inheritance exception, exception information:: %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
    }

    private Field[] getObjectAllFields(Object obj) {
        Object[] fields = obj.getClass().getDeclaredFields();
        Object[] superFields = obj.getClass().getSuperclass().getDeclaredFields();
        ArrayList fieldList = CollUtil.newArrayList((Object[])fields);
        fieldList.addAll(CollUtil.newArrayList((Object[])superFields));
        return (Field[])Convert.convert(Field[].class, (Object)fieldList);
    }

    public Object getFieldValueByName(String fieldName, Object obj) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = obj.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(obj, new Object[0]);
            return value;
        }
        catch (Exception e) {
            String exceptionMsg = String.format("Abnormal reflection, abnormal message: %s", e.getMessage());
            throw new DefinedException(exceptionMsg);
        }
    }

    public Map<String, Object> mapExtendsKeyValue(Map sourceMap, Map targetMap) {
        if (MapUtil.isEmpty((Map)targetMap)) {
            targetMap = Maps.newHashMap();
        }
        targetMap.putAll(MapUtil.isEmpty((Map)sourceMap) ? Maps.newHashMap() : sourceMap);
        return targetMap;
    }
}

