/*
 * Decompiled with CFR 0.152.
 */
package vip.lematech.hrun4j.config;

import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import vip.lematech.hrun4j.common.DefinedException;
import vip.lematech.hrun4j.helper.JavaIdentifierHelper;

public class RunnerConfig {
    private String i18n;
    private String dotEnvPath;
    private RunMode runMode = RunMode.POM;
    private File workDirectory;
    private String pkgName;
    private String testCaseExtName = "yml";
    private List<String> testCasePaths = new ArrayList<String>();
    private static RunnerConfig instance = new RunnerConfig();

    public String getDotEnvPath() {
        return this.dotEnvPath;
    }

    public void setDotEnvPath(String dotEnvPath) {
        this.dotEnvPath = dotEnvPath;
    }

    public File getWorkDirectory() {
        return Objects.isNull(this.workDirectory) ? new File(".") : this.workDirectory;
    }

    public String getPkgName() {
        return StrUtil.isEmpty((CharSequence)this.pkgName) ? "vip.lematech.hrun4j" : this.pkgName;
    }

    public void setPkgName(String pkgName) {
        if (!JavaIdentifierHelper.isValidJavaFullClassName(pkgName)) {
            String exceptionMsg = String.format("The package name %s is invalid", pkgName);
            throw new DefinedException(exceptionMsg);
        }
        this.pkgName = pkgName;
    }

    private RunnerConfig() {
    }

    public static RunnerConfig getInstance() {
        return instance;
    }

    public String getI18n() {
        return this.i18n;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public String getTestCaseExtName() {
        return this.testCaseExtName;
    }

    public List<String> getTestCasePaths() {
        return this.testCasePaths;
    }

    public void setI18n(String i18n) {
        this.i18n = i18n;
    }

    public void setRunMode(RunMode runMode) {
        this.runMode = runMode;
    }

    public void setWorkDirectory(File workDirectory) {
        this.workDirectory = workDirectory;
    }

    public void setTestCaseExtName(String testCaseExtName) {
        this.testCaseExtName = testCaseExtName;
    }

    public void setTestCasePaths(List<String> testCasePaths) {
        this.testCasePaths = testCasePaths;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunnerConfig)) {
            return false;
        }
        RunnerConfig other = (RunnerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$i18n = this.getI18n();
        String other$i18n = other.getI18n();
        if (this$i18n == null ? other$i18n != null : !this$i18n.equals(other$i18n)) {
            return false;
        }
        String this$dotEnvPath = this.getDotEnvPath();
        String other$dotEnvPath = other.getDotEnvPath();
        if (this$dotEnvPath == null ? other$dotEnvPath != null : !this$dotEnvPath.equals(other$dotEnvPath)) {
            return false;
        }
        RunMode this$runMode = this.getRunMode();
        RunMode other$runMode = other.getRunMode();
        if (this$runMode == null ? other$runMode != null : !((Object)((Object)this$runMode)).equals((Object)other$runMode)) {
            return false;
        }
        File this$workDirectory = this.getWorkDirectory();
        File other$workDirectory = other.getWorkDirectory();
        if (this$workDirectory == null ? other$workDirectory != null : !((Object)this$workDirectory).equals(other$workDirectory)) {
            return false;
        }
        String this$pkgName = this.getPkgName();
        String other$pkgName = other.getPkgName();
        if (this$pkgName == null ? other$pkgName != null : !this$pkgName.equals(other$pkgName)) {
            return false;
        }
        String this$testCaseExtName = this.getTestCaseExtName();
        String other$testCaseExtName = other.getTestCaseExtName();
        if (this$testCaseExtName == null ? other$testCaseExtName != null : !this$testCaseExtName.equals(other$testCaseExtName)) {
            return false;
        }
        List<String> this$testCasePaths = this.getTestCasePaths();
        List<String> other$testCasePaths = other.getTestCasePaths();
        return !(this$testCasePaths == null ? other$testCasePaths != null : !((Object)this$testCasePaths).equals(other$testCasePaths));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RunnerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $i18n = this.getI18n();
        result = result * 59 + ($i18n == null ? 43 : $i18n.hashCode());
        String $dotEnvPath = this.getDotEnvPath();
        result = result * 59 + ($dotEnvPath == null ? 43 : $dotEnvPath.hashCode());
        RunMode $runMode = this.getRunMode();
        result = result * 59 + ($runMode == null ? 43 : ((Object)((Object)$runMode)).hashCode());
        File $workDirectory = this.getWorkDirectory();
        result = result * 59 + ($workDirectory == null ? 43 : ((Object)$workDirectory).hashCode());
        String $pkgName = this.getPkgName();
        result = result * 59 + ($pkgName == null ? 43 : $pkgName.hashCode());
        String $testCaseExtName = this.getTestCaseExtName();
        result = result * 59 + ($testCaseExtName == null ? 43 : $testCaseExtName.hashCode());
        List<String> $testCasePaths = this.getTestCasePaths();
        result = result * 59 + ($testCasePaths == null ? 43 : ((Object)$testCasePaths).hashCode());
        return result;
    }

    public String toString() {
        return "RunnerConfig(i18n=" + this.getI18n() + ", dotEnvPath=" + this.getDotEnvPath() + ", runMode=" + (Object)((Object)this.getRunMode()) + ", workDirectory=" + this.getWorkDirectory() + ", pkgName=" + this.getPkgName() + ", testCaseExtName=" + this.getTestCaseExtName() + ", testCasePaths=" + this.getTestCasePaths() + ")";
    }

    public static enum RunMode {
        CLI,
        POM,
        PLATFORM;

    }
}

